/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.stream.Stream;

public final class FileHelper {
    private FileHelper() {
    }

    public static void deleteDirectory(String directoryPath) throws IOException {
        if (new File(directoryPath).isDirectory()) {
            try (Stream<Path> pathStream = Files.walk(Paths.get(directoryPath, new String[0]), new FileVisitOption[0]);){
                pathStream.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
            }
        }
    }

    public static void createDirectory(String dirPath) {
        if (!new File(dirPath).mkdirs()) {
            throw new IllegalArgumentException("Failed to create directory " + dirPath);
        }
    }

    public static boolean isFileNotExist(String filePath) {
        return !FileHelper.isFileExist(filePath);
    }

    public static boolean isFileExist(String filePath) {
        return new File(filePath).isFile();
    }

    public static void renameFile(String oldFilePath, String newFilePath) {
        File oldFile = new File(oldFilePath);
        File newFile = new File(newFilePath);
        if (!oldFile.renameTo(newFile)) {
            throw new IllegalArgumentException("Failed to rename file " + oldFilePath + " to " + newFilePath);
        }
    }

    public static boolean isDirectoryExist(String dirPath) {
        return new File(dirPath).isDirectory();
    }
}

