/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.helpers;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.stream.Stream;

public class FileHelper {
    public static void renameFile(String oldFilePath, String newFilePath) {
        File oldFile = new File(oldFilePath);
        File newFile = new File(newFilePath);
        if (!oldFile.renameTo(newFile)) {
            throw new RuntimeException("Failed to rename file " + oldFilePath + " to " + newFilePath);
        }
    }

    public static boolean isFileExist(String filePath) {
        return new File(filePath).isFile();
    }

    public static boolean isDirectoryExist(String dirPath) {
        return new File(dirPath).isDirectory();
    }

    public static void createDir(String directoryPath) {
        if (FileHelper.isDirectoryExist(directoryPath)) {
            return;
        }
        if (!new File(directoryPath).mkdirs()) {
            throw new RuntimeException("Failed to create directory " + directoryPath);
        }
    }

    public static void cleanDirectory(String directoryPath) throws IOException {
        if (new File(directoryPath).isDirectory()) {
            try (Stream<Path> pathStream = Files.walk(Paths.get(directoryPath, new String[0]), new FileVisitOption[0]);){
                pathStream.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
            }
        }
    }
}

