/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class ManifestVersion {
    private static final String MANIFEST_TAG = "manifest";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String VERSION_2 = "v2_0";

    private ManifestVersion() {
    }

    public static boolean isV2(String manifestPath) throws XMLStreamException, IOException {
        try (InputStream manifestInputStream = Files.newInputStream(Paths.get(manifestPath, new String[0]), new OpenOption[0]);){
            boolean bl = ManifestVersion.isManifestVersion2(manifestInputStream);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isManifestVersion2(InputStream manifestInputStream) throws XMLStreamException {
        boolean isNewPackage = false;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try (XMLStreamReader xmlStreamReader = null;){
            String encoding = Charset.defaultCharset().displayName();
            xmlStreamReader = inputFactory.createXMLStreamReader(manifestInputStream, encoding);
            while (xmlStreamReader.hasNext()) {
                String nodeName;
                if (xmlStreamReader.next() != 1 || !MANIFEST_TAG.equalsIgnoreCase(nodeName = xmlStreamReader.getLocalName().trim())) continue;
                String versionValue = ManifestVersion.getManifestVersion(xmlStreamReader);
                isNewPackage = versionValue != null && versionValue.equals(VERSION_2);
                break;
            }
        }
        return isNewPackage;
    }

    private static String getManifestVersion(XMLStreamReader xmlStreamReader) {
        String attributeValue = xmlStreamReader.getAttributeValue(null, VERSION_ATTRIBUTE);
        if (attributeValue != null) {
            return attributeValue.trim();
        }
        return null;
    }
}

