/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class PaxExtractor {
    private static final String IBM_1047 = "IBM-1047";

    private PaxExtractor() {
    }

    public static void extract(String packageZipFilePath, String outDir) throws Exception {
        System.out.println(" Extracting files from " + packageZipFilePath);
        String[] paxExtractCommandArgs = new String[]{"pax", "-rvf", packageZipFilePath};
        ProcessBuilder builder = new ProcessBuilder(paxExtractCommandArgs).directory(new File(outDir));
        Process process = builder.start();
        process.getOutputStream().close();
        PaxExtractor.printStream(process.getInputStream());
        PaxExtractor.printStream(process.getErrorStream());
        int exitCode = process.waitFor();
        if (exitCode > 0) {
            throw new RuntimeException("pax command failed with exit code - " + exitCode);
        }
    }

    private static void printStream(InputStream inputStream) throws IOException {
        try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(inputStream, IBM_1047));){
            String line;
            while ((line = stdInput.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

