/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class ZipCompressor {
    private ZipCompressor() {
    }

    public static void compress(String outputZipPath, List<String> files) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputZipPath);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            for (String file : files) {
                ZipCompressor.addFileToZip(file, zipOutputStream);
            }
        }
    }

    private static void addFileToZip(String filePath, ZipOutputStream zipOutputStream) throws IOException {
        File versionFile = new File(filePath);
        try (FileInputStream fis = new FileInputStream(versionFile);){
            int length;
            ZipEntry zipEntry = new ZipEntry(versionFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOutputStream.write(bytes, 0, length);
            }
            zipOutputStream.closeEntry();
        }
    }
}

