/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.download.ExtRepoDownloadInputs;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class ExtRepoHelper {
    private static final int BYTE_SIZE = 0x200000;

    private ExtRepoHelper() {
    }

    public static void download(ExtRepoDownloadInputs pluginInputs, String downloadZipFilePath) throws IOException {
        ExtRepoHelper extRepoHelper = new ExtRepoHelper();
        HttpClientBuilder2 clientBuilder = extRepoHelper.getInitializedBuilder(pluginInputs);
        try (CloseableHttpClient client = clientBuilder.buildClient();){
            extRepoHelper.downloadZipFromExternalRepo(client, pluginInputs.getExtRepoURL(), downloadZipFilePath);
        }
    }

    private HttpClientBuilder2 getInitializedBuilder(ExtRepoDownloadInputs pluginInputs) {
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        builder.setPreemptiveAuthentication(true);
        if (!pluginInputs.getUsername().isEmpty()) {
            builder.setUsername(pluginInputs.getUsername());
            String password = pluginInputs.getApiKey().isEmpty() ? pluginInputs.getPassword() : pluginInputs.getApiKey();
            builder.setPassword(password);
        }
        if (!pluginInputs.getHttpProxyHost().isEmpty()) {
            System.out.println(" [Info] Using Proxy Host " + pluginInputs.getHttpProxyHost());
            builder.setProxyHost(pluginInputs.getHttpProxyHost());
        }
        if (!pluginInputs.getHttpProxyPort().isEmpty()) {
            System.out.println(" [Info] Using Proxy Port " + pluginInputs.getHttpProxyPort());
            builder.setProxyPort(Integer.parseInt(pluginInputs.getHttpProxyPort()));
        }
        if (pluginInputs.isInsecureConnectionAllowed()) {
            System.out.println("[Info] Allowing insecure connections. Review with your security admins before allowing insecure connections...");
            builder.setTrustAllCerts(true);
        }
        return builder;
    }

    private HttpResponse getOkResponse(CloseableHttpClient client, String url) throws IOException {
        HttpGet get = new HttpGet(url);
        get.addHeader("accept", "application/json");
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("HTTP response error code =" + response.getStatusLine().getStatusCode() + "\nResponse=" + response.toString().replace("\n", ""));
        }
        System.out.println(" [Info] HTTP response is success");
        return response;
    }

    private void downloadZipFromExternalRepo(CloseableHttpClient client, String externalRepoUrl, String downloadZipFilePath) throws IOException {
        System.out.println(" [Info] Attempting to download version from external repository...");
        HttpResponse response = this.getOkResponse(client, externalRepoUrl);
        File downloadZipFile = new File(downloadZipFilePath);
        downloadZipFile.deleteOnExit();
        try (InputStream inputStream = response.getEntity().getContent();){
            this.writeToZipFile(inputStream, downloadZipFile);
        }
        System.out.println(" [Info] Downloaded compressed version file from external repository to " + downloadZipFilePath);
    }

    private void writeToZipFile(InputStream inputStream, File downloadZipFile) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(downloadZipFile);){
            int read;
            byte[] buffer = new byte[0x200000];
            while ((read = inputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, read);
            }
        }
    }
}

