/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.BadEnvelopeException;
import com.urbancode.air.securedata.Envelope;
import com.urbancode.air.securedata.EnvelopeCodec;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.SecretContainer2;
import java.security.GeneralSecurityException;

public class SecureBlob {
    private byte[] data;
    private EnvelopeCodec codec;

    public static SecureBlob fromUnencryptedBytes(SecretContainer secret, byte[] data) throws GeneralSecurityException, BadEnvelopeException {
        secret.getClass();
        data.getClass();
        String suite = null;
        if (secret instanceof SecretContainer2) {
            suite = ((SecretContainer2)secret).getCryptoSuite();
        }
        EnvelopeCodec codec = EnvelopeCodec.builder().setSecret(secret).setCryptoSuite(suite).build();
        Envelope envelope = new Envelope(data);
        return new SecureBlob(codec, envelope, false);
    }

    public static SecureBlob fromEncryptedBytes(SecretContainer secret, byte[] data) throws GeneralSecurityException, BadEnvelopeException {
        secret.getClass();
        data.getClass();
        Envelope envelope = Envelope.fromBytes(data);
        String cryptoSuite = envelope.getHeader().getCryptoSuite();
        if (cryptoSuite == null) {
            throw new BadEnvelopeException("no crypto suite");
        }
        EnvelopeCodec codec = EnvelopeCodec.builder().setCryptoSuite(cryptoSuite).setSecret(secret).build();
        return new SecureBlob(codec, envelope, true);
    }

    SecureBlob(EnvelopeCodec codec, Envelope envelope, boolean encrypted) throws GeneralSecurityException {
        this.codec = codec;
        this.data = encrypted ? envelope.toBytes() : this.encrypt(envelope);
    }

    public synchronized byte[] getEncryptedBytes() {
        return this.data;
    }

    public synchronized byte[] get() throws BadEnvelopeException, GeneralSecurityException {
        Envelope envelope = Envelope.fromBytes(this.data);
        this.codec.decodeBody(envelope);
        return envelope.getBody();
    }

    public synchronized void set(byte[] data) throws GeneralSecurityException, BadEnvelopeException {
        data.getClass();
        this.data = this.encrypt(data);
    }

    private byte[] encrypt(byte[] data) throws BadEnvelopeException, GeneralSecurityException {
        Envelope envelope = new Envelope(data);
        return this.encrypt(envelope);
    }

    private byte[] encrypt(Envelope envelope) throws BadEnvelopeException, GeneralSecurityException {
        this.codec.encodeBody(envelope);
        return envelope.toBytes();
    }
}

