/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public final class CustomPropertiesParser {
    private static final char PROPERTY_SEPARATOR = '=';
    private static final String EMPTY_STRING = "";
    private static final String REGEX_FOR_PROPERTY = ".+=.*";

    private CustomPropertiesParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> parseIntoMap(String propertyLines) {
        HashMap<String, String> map = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(propertyLines));){
            String propertyLine;
            while ((propertyLine = reader.readLine()) != null) {
                if (propertyLine.isEmpty()) continue;
                CustomPropertiesParser.loadPropertyIntoMap(propertyLine, map);
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Failed to read custom properties");
        }
    }

    private static void loadPropertyIntoMap(String propertyLine, Map<String, String> map) {
        if (CustomPropertiesParser.isInvalidProperty(propertyLine)) {
            throw new IllegalArgumentException("Invalid Custom property found - " + propertyLine);
        }
        int separatorIndex = propertyLine.indexOf(61);
        String propertyName = propertyLine.substring(0, separatorIndex).trim();
        String propertyValue = CustomPropertiesParser.isPropertyValueEmpty(propertyLine) ? EMPTY_STRING : propertyLine.substring(separatorIndex + 1);
        map.put(propertyName, propertyValue);
    }

    private static boolean isInvalidProperty(String propertyLine) {
        return !propertyLine.matches(REGEX_FOR_PROPERTY);
    }

    private static boolean isPropertyValueEmpty(String propertyLine) {
        int lastIndex = propertyLine.length() - 1;
        return propertyLine.indexOf(61) == lastIndex;
    }
}

