/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ds.client.AddVersionFilesCommandHelper;
import com.urbancode.vfs.common.ClientPathEntry;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class AddVersionFilesCommand {
    static final ContentType TEXT_PLAIN_UTF8 = ContentType.TEXT_PLAIN.withCharset(IO.utf8());
    private MultipartEntityBuilder multipartBuilder;
    private AddVersionFilesCommandHelper helper;

    AddVersionFilesCommand(MultipartEntityBuilder multipartBuilder, AddVersionFilesCommandHelper helper) {
        this.multipartBuilder = multipartBuilder;
        this.multipartBuilder.getClass();
        this.helper = helper;
        this.helper.getClass();
    }

    @Deprecated
    public AddVersionFilesCommand(String baseUrl, HttpClient client, String component, String version, File base, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose) {
        this(baseUrl, client, component, version, base, offset, includes, excludes, saveExecuteBits, verbose, null, new String[0]);
    }

    public AddVersionFilesCommand(String baseUrl, HttpClient client, String component, String version, File base, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose, Charset charset, String[] extensions) {
        this(MultipartEntityBuilder.create(), new AddVersionFilesCommandHelper(component, version, offset, baseUrl, base, includes, excludes, charset, extensions, client, saveExecuteBits, verbose));
    }

    public void execute() throws Exception {
        ClientPathEntry[] entries = this.helper.getEntries();
        if (!StringUtil.isEmpty(this.helper.component)) {
            this.multipartBuilder.addTextBody("component", this.helper.component, TEXT_PLAIN_UTF8);
        }
        this.multipartBuilder.addTextBody("version", this.helper.version, TEXT_PLAIN_UTF8);
        HashSet<String> handledHashes = new HashSet<String>();
        for (ClientPathEntry entry : entries) {
            this.multipartBuilder.addTextBody("entryMetadata", entry.toJSON().toString(), TEXT_PLAIN_UTF8);
            if (entry.getType() != FileType.REGULAR) continue;
            String path = entry.getPath();
            File file = this.helper.getFile(path);
            String hash = entry.getContentHash().getValue();
            if (file.isFile() && handledHashes.add(hash)) {
                this.multipartBuilder.addBinaryBody("entryContent-" + hash, file);
            }
            if (!this.helper.verbose) continue;
            System.out.println("Uploading file " + file.getPath());
        }
        HttpEntity entity = this.multipartBuilder.build();
        try {
            this.helper.post(entity);
        }
        catch (Exception e) {
            try {
                this.helper.post(entity);
            }
            catch (Exception e1) {
                e1.addSuppressed(e);
                try {
                    this.helper.post(entity);
                }
                catch (Exception e2) {
                    e2.addSuppressed(e1);
                    throw new RuntimeException(String.format("%s\n%s\n%s", e, e1, e2));
                }
            }
        }
    }
}

