/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.ImportVersionInputs;
import com.urbancode.air.plugin.command.SystemEnv;
import com.urbancode.air.plugin.command.UcdClientHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import org.apache.log4j.PropertyConfigurator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ImportVersion {
    private static final String TIMESTAMP_FORMAT = "yyyyMMdd-HHmmss";
    private static final String NONE_TIMESTAMP = "NONE";
    private static final String SHIPLIST = "shiplist";
    private static final String XML = ".xml";
    private static final String AGENT_LOG_4_J_PROPERTIES = "conf/agent/log4j.properties";
    private static final String BIN = "bin";
    private static final String LAST_VERSION = "LASTVERSION";
    private static final String VERSION_NAME = "VersionName";
    private static final String VERSION_ID = "VersionID";
    private static final String PRESENT_WORKING_DIRECTORY = ".";
    private static final String BUZTOOL_SH = "buztool.sh";
    private final Properties inputProperties;
    private final Properties outputProperties;
    private final UcdClientHelper ucdClientHelper;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
        this.ucdClientHelper = new UcdClientHelper();
    }

    public int execute() {
        try {
            ImportVersionInputs pluginInputs = new ImportVersionInputs(this.inputProperties);
            this.configureLog4j();
            String versionName = pluginInputs.getVersionNameWithPrefix();
            String shiplistFilePath = this.getShiplistFilePath(pluginInputs);
            List<String> createVersionCommandList = this.getBuztoolCommandList(pluginInputs, versionName, shiplistFilePath);
            if (!pluginInputs.getSinceTimeStamp().isEmpty() && !pluginInputs.getSinceTimeStamp().equalsIgnoreCase(NONE_TIMESTAMP)) {
                String timeStamp = this.getTimeStamp(pluginInputs);
                createVersionCommandList.add("-sincetimestamp");
                createVersionCommandList.add(timeStamp);
            }
            System.out.println("Creating new version: " + versionName);
            int exitCode = this.runBuztoolScript(createVersionCommandList);
            if (exitCode > 0) {
                throw new RuntimeException("Failed to create new version: " + versionName);
            }
            String versionId = this.ucdClientHelper.getVersionId(pluginInputs.getComponentName(), versionName);
            this.outputProperties.put(VERSION_NAME, versionName);
            this.outputProperties.put(VERSION_ID, versionId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
        return 0;
    }

    private void configureLog4j() throws IOException {
        Properties props = new Properties();
        props.load(Files.newInputStream(new File(SystemEnv.getAgentHome(), AGENT_LOG_4_J_PROPERTIES).toPath(), new OpenOption[0]));
        PropertyConfigurator.configure((Properties)props);
    }

    private String getShiplistFilePath(ImportVersionInputs pluginInputs) throws IOException {
        if (!pluginInputs.getShiplistContent().isEmpty()) {
            return this.createTemporaryShiplistFile(pluginInputs.getShiplistContent());
        }
        if (!pluginInputs.getShiplistFilePath().isEmpty()) {
            return pluginInputs.getShiplistFilePath();
        }
        if (!pluginInputs.getDefaultShiplistContent().isEmpty()) {
            return this.createTemporaryShiplistFile(pluginInputs.getDefaultShiplistContent());
        }
        if (!pluginInputs.getDefaultShiplistFilePath().isEmpty()) {
            return pluginInputs.getDefaultShiplistFilePath();
        }
        throw new IllegalArgumentException("Shiplist is required. Specify either the shiplist content or the path to a shiplist file.");
    }

    private String createTemporaryShiplistFile(String shiplistContent) throws IOException {
        File tempShiplistFile = File.createTempFile(SHIPLIST, XML, new File(PRESENT_WORKING_DIRECTORY));
        tempShiplistFile.deleteOnExit();
        String shiplistFilePath = tempShiplistFile.getPath();
        ImportVersion.writeStringToFile(shiplistContent, shiplistFilePath);
        return shiplistFilePath;
    }

    private String getTimeStamp(ImportVersionInputs pluginInputs) throws Exception {
        if (pluginInputs.getSinceTimeStamp().equalsIgnoreCase(LAST_VERSION)) {
            Optional<String> lastVersionCreatedTimeStamp = this.getLastVersionCreatedTimeStamp(pluginInputs);
            if (lastVersionCreatedTimeStamp.isPresent()) {
                return lastVersionCreatedTimeStamp.get();
            }
            System.out.println("No version in this component");
            return NONE_TIMESTAMP;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_FORMAT);
        Date date = sdf.parse(pluginInputs.getSinceTimeStamp());
        return sdf.format(date);
    }

    private Optional<String> getLastVersionCreatedTimeStamp(ImportVersionInputs pluginInputs) throws IOException, JSONException, URISyntaxException {
        JSONObject latestVersion = this.ucdClientHelper.getLatestComponentVersion(pluginInputs.getComponentName());
        if (latestVersion != null) {
            long createdTimestamp = latestVersion.getLong("created");
            Timestamp versionCreatedTimestamp = new Timestamp(createdTimestamp);
            SimpleDateFormat dateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
            return Optional.of(dateFormat.format(versionCreatedTimestamp));
        }
        return Optional.empty();
    }

    private List<String> getBuztoolCommandList(ImportVersionInputs pluginInputs, String versionName, String shiplistFilePath) {
        String toolkitExecPath = SystemEnv.getToolkitHome() + File.separator + BIN + File.separator + BUZTOOL_SH;
        ArrayList<String> createVersionCommandList = new ArrayList<String>();
        createVersionCommandList.add(toolkitExecPath);
        createVersionCommandList.add(pluginInputs.getPackageFormat().toString().toLowerCase());
        createVersionCommandList.add("-c");
        createVersionCommandList.add(pluginInputs.getComponentName());
        createVersionCommandList.add("-v");
        createVersionCommandList.add(versionName);
        createVersionCommandList.add("-s");
        createVersionCommandList.add(shiplistFilePath);
        if (!pluginInputs.getBuztoolPropertiesFilePath().isEmpty()) {
            createVersionCommandList.add("-prop");
            createVersionCommandList.add(pluginInputs.getBuztoolPropertiesFilePath());
        }
        return createVersionCommandList;
    }

    private int runBuztoolScript(List<String> createVersionCommandList) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(createVersionCommandList);
        System.out.println(pb.command());
        Process createVersionProcess = pb.start();
        this.printProcessMessage(createVersionProcess.getInputStream());
        this.printProcessMessage(createVersionProcess.getErrorStream());
        return createVersionProcess.waitFor();
    }

    public static void writeStringToFile(String s, String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write(s);
        }
    }

    private void printProcessMessage(InputStream src) {
        try (Scanner sc = new Scanner(src);){
            while (sc.hasNextLine()) {
                System.out.println(sc.nextLine());
            }
        }
    }
}

