/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.PackageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class ImportVersionInputs {
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION = "version";
    public static final String VERSION_NAME_PREFIX = "versionNamePrefix";
    public static final String SHIPLIST_CONTENT = "shiplistContent";
    public static final String SHIPLIST_FILE_PATH = "shiplitFilePath";
    public static final String DEFAULT_SHIPLIST_CONTENT = "defaultShiplistContent";
    public static final String DEFAULT_SHIPLIST_FILE_PATH = "defaultShiplitFilePath";
    public static final String PACKAGE_AFTER_TIMESTAMP = "packageAfterTimestamp";
    public static final String PACKAGE_FORMAT = "packageFormat";
    public static final String PROPERTIES_FILE_PATH = "propertiesFilePath";
    private final String componentName;
    private final String versionNamePrefix;
    private final String versionName;
    private final String shiplistContent;
    private final String shiplistFilePath;
    private final String defaultShiplistContent;
    private final String defaultShiplistFilePath;
    private final String sinceTimeStamp;
    private final PackageFormat packageFormat;
    private final String buztoolPropertiesFilePath;

    public ImportVersionInputs(Properties inputProperties) {
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION).trim();
        this.versionNamePrefix = inputProperties.getProperty(VERSION_NAME_PREFIX).trim();
        this.shiplistContent = inputProperties.getProperty(SHIPLIST_CONTENT).trim();
        this.shiplistFilePath = inputProperties.getProperty(SHIPLIST_FILE_PATH).trim();
        this.defaultShiplistContent = inputProperties.getProperty(DEFAULT_SHIPLIST_CONTENT).trim();
        this.defaultShiplistFilePath = inputProperties.getProperty(DEFAULT_SHIPLIST_FILE_PATH).trim();
        this.sinceTimeStamp = inputProperties.getProperty(PACKAGE_AFTER_TIMESTAMP).trim();
        this.packageFormat = PackageFormat.valueOf(inputProperties.getProperty(PACKAGE_FORMAT, PackageFormat.CREATEZOSVERSION.toString()));
        this.buztoolPropertiesFilePath = inputProperties.getProperty(PROPERTIES_FILE_PATH, "").trim();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionNameWithPrefix() {
        String versionName = this.versionName;
        if (versionName.isEmpty()) {
            versionName = new SimpleDateFormat("yyyyMMdd-HHmm").format(new Date());
        }
        if (!this.versionNamePrefix.isEmpty()) {
            versionName = this.versionNamePrefix + versionName;
        }
        return versionName;
    }

    public String getShiplistContent() {
        return this.shiplistContent;
    }

    public String getShiplistFilePath() {
        return this.shiplistFilePath;
    }

    public String getDefaultShiplistContent() {
        return this.defaultShiplistContent;
    }

    public String getDefaultShiplistFilePath() {
        return this.defaultShiplistFilePath;
    }

    public String getSinceTimeStamp() {
        return this.sinceTimeStamp;
    }

    public PackageFormat getPackageFormat() {
        return this.packageFormat;
    }

    public String getBuztoolPropertiesFilePath() {
        return this.buztoolPropertiesFilePath;
    }
}

