/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.codehaus.jettison.json.JSONObject;

public class ImportVersion {
    private static final String TIMSTAMP_FORMAT = "yyyyMMdd-HHmmss";
    private static final String NONE_TIMESTEAMP = "NONE";
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int execute() {
        try {
            int infoChar;
            File currentDirectory = new File(".").getCanonicalFile();
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String componentName = this.inputProperties.getProperty("componentName");
            boolean enableVerbose = false;
            String versionName = this.inputProperties.getProperty("version");
            String versionNamePrefix = this.inputProperties.getProperty("versionNamePrefix");
            if (StringUtils.isBlank((String)versionName)) {
                versionName = new SimpleDateFormat("yyyyMMdd-HHmm").format(new Date());
            }
            if (!StringUtils.isBlank((String)versionNamePrefix)) {
                versionName = versionNamePrefix.trim() + versionName;
            }
            String shiplitFilePath = "";
            String shiplistContent = this.inputProperties.getProperty("shiplistContent");
            if (StringUtils.isBlank((String)shiplistContent) && StringUtils.isBlank((String)(shiplitFilePath = this.inputProperties.getProperty("shiplitFilePath"))) && StringUtils.isBlank((String)(shiplistContent = this.inputProperties.getProperty("defaultShiplistContent")))) {
                shiplitFilePath = this.inputProperties.getProperty("defaultShiplitFilePath");
            }
            if (StringUtils.isBlank((String)shiplitFilePath)) {
                if (StringUtils.isBlank((String)shiplistContent)) {
                    throw new Exception("Shiplist is required. Specify either the shiplist content or the path to a shiplist file.");
                }
                File temp = File.createTempFile("shiplist", ".xml", currentDirectory);
                temp.deleteOnExit();
                shiplitFilePath = temp.getPath();
                Path path = Paths.get(shiplitFilePath, new String[0]);
                String charsetName = agentProps.getProperty("system.default.encoding");
                byte[] data = shiplistContent.getBytes(charsetName);
                Files.write(path, data, new OpenOption[0]);
            }
            String toolkitHome = System.getenv().get("BUZ_TOOLKIT_HOME");
            String toolkitExecPath = toolkitHome + File.separator + "bin" + File.separator + "buztool.sh";
            LinkedList<String> createVersionCommandList = new LinkedList<String>();
            createVersionCommandList.add(toolkitExecPath);
            createVersionCommandList.add("createzosversion");
            createVersionCommandList.add("-c");
            createVersionCommandList.add(componentName);
            createVersionCommandList.add("-v");
            createVersionCommandList.add(versionName);
            createVersionCommandList.add("-s");
            createVersionCommandList.add(shiplitFilePath);
            String timeStamp = this.inputProperties.getProperty("packageAfterTimestamp");
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            if (!StringUtils.isBlank((String)timeStamp)) {
                String toolkitVersion = System.getenv().get("BUZ_TOOLKIT_VERSION");
                if (StringUtils.isBlank((String)toolkitVersion)) throw new PluginExecutionException("Toolkit version 6.2.2 or later is required to use the 'Since Time Stamp' option");
                if (toolkitVersion.compareTo("6.2.1.2") <= 0) throw new PluginExecutionException("Toolkit version 6.2.2 or later is required to use the 'Since Time Stamp' option");
                if (StringUtils.equalsIgnoreCase((String)"LASTVERSION", (String)timeStamp)) {
                    ComponentClient componentClient = new ComponentClient(url, username, password);
                    JSONObject latestVersion = componentClient.getLatestVersionJson(componentName);
                    if (null != latestVersion) {
                        Long createdTimestap = latestVersion.getLong("created");
                        Timestamp versionCreatedTimestamp = new Timestamp(createdTimestap);
                        SimpleDateFormat sdf = new SimpleDateFormat(TIMSTAMP_FORMAT);
                        timeStamp = sdf.format(versionCreatedTimestamp);
                    } else {
                        timeStamp = NONE_TIMESTEAMP;
                        System.out.println("No version in this component");
                    }
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat(TIMSTAMP_FORMAT);
                    Date date = sdf.parse(timeStamp);
                    timeStamp = sdf.format(date);
                }
                if (StringUtils.isBlank((String)timeStamp)) throw new PluginExecutionException("Import version failed because an invalid time stamp is specified. Time stamp must be in the YYYYMMDD-HHmmss format. Input LASTVERSION to select data sets changed since last version. Leave blank to ignore the time stamp criterion and select all data sets in the shiplist.");
                if (!StringUtils.equalsIgnoreCase((String)NONE_TIMESTEAMP, (String)timeStamp)) {
                    createVersionCommandList.add("-sincetimestamp");
                    createVersionCommandList.add(timeStamp);
                }
            }
            if (enableVerbose) {
                createVersionCommandList.add("-verbose");
                createVersionCommandList.add("true");
            }
            ProcessBuilder pb = new ProcessBuilder(createVersionCommandList);
            System.out.println(String.format("Creating new version %s.", versionName));
            System.out.println(pb.command());
            Process createVersionProcess = pb.start();
            createVersionProcess.waitFor();
            InputStream shellIn = createVersionProcess.getInputStream();
            while ((infoChar = shellIn.read()) != -1) {
                System.out.write(infoChar);
            }
            if (createVersionProcess.exitValue() != 0) {
                InputStream error = createVersionProcess.getErrorStream();
                for (int i = 0; i < error.available(); ++i) {
                    System.out.println("" + error.read());
                }
                throw new PluginExecutionException(String.format("Failed to create new version: %s", versionName));
            }
            this.outputProperties.put("VersionName", versionName);
            VersionClient versionClient = new VersionClient(url, username, password);
            String versionId = versionClient.getVersionId(componentName, versionName).toString();
            this.outputProperties.put("VersionID", versionId);
            createVersionProcess.destroy();
            return 0;
        }
        catch (Exception e) {
            System.err.println(String.format("Error creating new version: %s", e.getMessage()));
            e.printStackTrace();
            return 1;
        }
    }
}

