/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ErrnoException;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZUtil;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

class Spawn {
    private FileDescriptor childIn = new FileDescriptor();
    private FileDescriptor childOut = new FileDescriptor();
    private FileDescriptor childErr = new FileDescriptor();
    private InputStream childStdoutStream;
    private InputStream childStderrStream;
    private OutputStream childStdinStream;
    private int childPid;
    private ArrayList stderrLines = new ArrayList();
    private Thread stderrThread;

    Spawn() {
    }

    public void execute(String path, String[] args, String[] env) throws ErrnoException {
        this.childPid = this.spawn(path, this.childIn, this.childOut, this.childErr, args, env);
        this.childStdinStream = new FileOutputStream(this.childIn);
        this.childStdoutStream = new FileInputStream(this.childOut){

            public int available() {
                return 0;
            }
        };
        this.childStderrStream = new FileInputStream(this.childErr){

            public int available() {
                return 0;
            }
        };
        this.readStderr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitChild() throws RcException {
        int rc;
        try {
            rc = this.waitPid(this.childPid);
        }
        finally {
            try {
                this.stderrThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return rc;
    }

    public OutputStream getChildStdinStream() {
        return this.childStdinStream;
    }

    public InputStream getChildStdoutStream() {
        return this.childStdoutStream;
    }

    public List getStderrLines() {
        return this.stderrLines;
    }

    private native int spawn(String var1, FileDescriptor var2, FileDescriptor var3, FileDescriptor var4, String[] var5, String[] var6) throws ErrnoException;

    private native int waitPid(int var1) throws RcException;

    private void readStderr() {
        this.stderrThread = new Thread(){

            public void run() {
                try {
                    String line;
                    BufferedReader rdr = new BufferedReader(new InputStreamReader(Spawn.this.childStderrStream, ZUtil.getDefaultPlatformEncoding()));
                    while ((line = rdr.readLine()) != null) {
                        Spawn.this.stderrLines.add(line);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
        this.stderrThread.start();
    }

    static {
        ZUtil.touch();
    }
}

