/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import java.io.IOException;
import java.io.InputStream;

public class RDWInputRecordStream {
    private InputStream is;
    private byte[] rdwBytes = new byte[4];

    public RDWInputRecordStream(InputStream is) {
        if (is == null) {
            throw new NullPointerException();
        }
        this.is = is;
    }

    public void close() throws IOException {
        this.is.close();
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0);
    }

    public int read(byte[] bytes, int offset) throws IOException {
        int recLen = this.readRdw();
        if (recLen == -1) {
            return -1;
        }
        this.readFully(bytes, offset, recLen);
        return recLen;
    }

    public byte[] read() throws IOException {
        int recLen = this.readRdw();
        if (recLen == -1) {
            return null;
        }
        byte[] record = new byte[recLen];
        this.readFully(record);
        return record;
    }

    private int readRdw() throws IOException {
        if (!this.readFully(this.rdwBytes)) {
            return -1;
        }
        int recLen = ByteUtil.bytesAsInt(this.rdwBytes, 0, 2);
        return recLen -= 4;
    }

    private boolean readFully(byte[] bytes) throws IOException {
        return this.readFully(bytes, 0, bytes.length);
    }

    private boolean readFully(byte[] bytes, int offset, int bytesToRead) throws IOException {
        int c = this.is.read();
        if (c == -1) {
            return false;
        }
        bytes[offset++] = (byte)c;
        --bytesToRead;
        while (bytesToRead > 0) {
            int bytesRead = this.is.read(bytes, offset, bytesToRead);
            if (bytesRead == -1) {
                throw new IOException("EOF encountered before all record bytes read");
            }
            bytesToRead -= bytesRead;
            offset += bytesRead;
        }
        return true;
    }
}

