/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Properties;

public class DatasetWriter {
    private Properties inputProperties;
    private Properties outputProperties;

    public DatasetWriter(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() {
        try {
            String zFileDsn;
            String inputText = this.inputProperties.getProperty("inputText");
            String zDataset = this.inputProperties.getProperty("zDataset").trim().toUpperCase();
            String allocateDataset = this.inputProperties.getProperty("allocateDataset").trim().toUpperCase();
            String deleteExistingDataset = this.inputProperties.getProperty("deleteExistingDataset").trim().toUpperCase();
            String volumeSerial = this.inputProperties.getProperty("volumeSerial").trim();
            String spaceUnit = this.inputProperties.getProperty("spaceUnit");
            String averRecUnit = this.inputProperties.getProperty("averRecUnit");
            int primaryQuantity = Integer.parseInt(this.inputProperties.getProperty("primaryQuantity").trim());
            int secondaryQuantity = Integer.parseInt(this.inputProperties.getProperty("secondaryQuantity").trim());
            String recordFormat = this.inputProperties.getProperty("recordFormat");
            int recordLength = Integer.parseInt(this.inputProperties.getProperty("recordLength").trim());
            int blockSize = Integer.parseInt(this.inputProperties.getProperty("blockSize").trim());
            boolean isAppend = this.inputProperties.getProperty("isAppend").toUpperCase().equals("TRUE");
            if (this.isNullOrEmpty(inputText)) {
                System.out.println(" [ERROR] Input Text cannot be null or empty");
                return 1;
            }
            if (this.isNullOrEmpty(zDataset)) {
                System.out.println(" [ERROR] Dataset name cannot be null or empty");
                return 1;
            }
            if (allocateDataset.equals("TRUE")) {
                if (deleteExistingDataset.equals("TRUE")) {
                    String zFileDataset = ZFile.getSlashSlashQuotedDSN((String)zDataset, (boolean)true);
                    if (ZFile.dsExists((String)zFileDataset)) {
                        System.out.println(" [INFO] Deleting existing dataset");
                        ZFile.remove((String)zFileDataset);
                    } else {
                        System.out.println(" [INFO] Dataset does not exist");
                    }
                }
                System.out.println(" [INFO] Allocating Dataset with passed paramters");
                String ddName = ZFile.allocDummyDDName();
                String createDatasetAlloc = "alloc fi(" + ddName + ") da(" + zDataset + ") dsorg(PS) lrecl(" + recordLength + ") blksize(" + blockSize + ") space(" + primaryQuantity + "," + secondaryQuantity + ") " + spaceUnit + " RECFM(" + recordFormat + ")  dir(0) reuse new catalog msg(wtp) ";
                if (!averRecUnit.equals("---")) {
                    createDatasetAlloc = createDatasetAlloc + "avgrec(" + averRecUnit + ") ";
                }
                if (!this.isNullOrEmpty(volumeSerial)) {
                    createDatasetAlloc = createDatasetAlloc + "vol(" + volumeSerial + ") ";
                }
                ZFile.bpxwdyn((String)createDatasetAlloc);
                ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            }
            if (!ZFile.dsExists((String)(zFileDsn = ZFile.getSlashSlashQuotedDSN((String)zDataset, (boolean)true)))) {
                System.out.println(" [ERROR] Dataset " + zDataset + " does not exist");
                return 1;
            }
            int availableRecLen = 0;
            ZFile zfile = new ZFile(zFileDsn, "rb,type=record");
            try {
                int recfmBits = zfile.getRecfmBits();
                int lrecl = zfile.getLrecl();
                if ((2 & recfmBits) != 0) {
                    lrecl -= 4;
                }
                availableRecLen = lrecl;
            }
            finally {
                zfile.close();
            }
            RecordWriter recordWriter = null;
            try {
                String line;
                recordWriter = isAppend ? RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)zDataset, (boolean)true), (int)8) : RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)zDataset, (boolean)true), (int)4);
                BufferedReader bufReader = new BufferedReader(new StringReader(inputText));
                int lineCount = 0;
                byte[] recBuf = null;
                String platformEncoding = ZUtil.getDefaultPlatformEncoding();
                while ((line = bufReader.readLine()) != null) {
                    ++lineCount;
                    String record = String.format("%-" + availableRecLen + "s", line.replaceAll("\\s+$", ""));
                    recBuf = record.getBytes(platformEncoding);
                    if (recBuf.length > availableRecLen) {
                        System.out.println(" [ERROR] Line number " + lineCount + " in input text exceeds available record length of dataset " + availableRecLen);
                        recordWriter.close();
                        int n = 1;
                        return n;
                    }
                    recordWriter.write(recBuf, 0, recBuf.length);
                }
            }
            finally {
                recordWriter.close();
            }
            if (isAppend) {
                System.out.println(" [INFO] Input Text is successfully appended to dataset " + zDataset);
                return 0;
            }
            System.out.println(" [INFO] Input Text is successfully written to dataset " + zDataset);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

