/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;

class ZFileRecordWriter
extends RecordWriter {
    protected ZFile zFile;
    private String ddname;
    private int blksize;
    private int lrecl;
    private int recfmBits;
    private String recfm;
    private String dsn;

    protected ZFileRecordWriter(ZFile zFile) throws ZFileException {
        this.zFile = zFile;
        this.blksize = zFile.getBlksize();
        this.lrecl = zFile.getLrecl();
        this.recfmBits = zFile.getRecfmBits();
        this.recfm = zFile.getRecfm();
        this.dsn = zFile.getActualFilename();
    }

    protected ZFileRecordWriter(String ddname) throws ZFileException {
        this(new ZFile("//DD:" + ddname, "wb,type=record,noseek,recfm=*"));
        this.ddname = ddname;
    }

    public void close() throws ZFileException {
        this.zFile.close();
        this.doAutoFree();
    }

    public int getBlksize() {
        return this.blksize;
    }

    public String getDDName() {
        return this.ddname;
    }

    public String getDsn() {
        return this.dsn;
    }

    public int getLrecl() {
        return this.lrecl;
    }

    public String getRecfm() {
        return this.recfm;
    }

    public int getRecfmBits() {
        return this.recfmBits;
    }

    public void write(byte[] buf) throws ZFileException {
        this.zFile.write(buf);
    }

    public void write(byte[] buf, int offset, int len) throws ZFileException {
        this.zFile.write(buf, offset, len);
    }

    public void flush() throws ZFileException {
        this.zFile.flush();
    }
}

