/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamFbRecordReader;
import com.ibm.jzos.BsamVRecordReader;
import com.ibm.jzos.BsamVbsRecordReader;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.ZFileException;

class BsamRecordReader
extends RecordReader {
    protected Bsam bsam;

    protected BsamRecordReader(Bsam bsam) {
        this.bsam = bsam;
    }

    public static RecordReader newReaderForDD(String ddname) throws ZFileException {
        Bsam bsam = new Bsam(ddname, 128);
        BsamRecordReader reader = null;
        if ((bsam.getRecfmBits() & 4) == 4) {
            reader = new BsamRecordReader(bsam);
        } else if ((bsam.getRecfmBits() & 1) == 1) {
            reader = (bsam.getRecfmBits() & 8) == 0 ? new BsamRecordReader(bsam) : new BsamFbRecordReader(bsam);
        } else if ((bsam.getRecfmBits() & 2) == 2) {
            reader = (bsam.getRecfmBits() & 0x10) == 16 ? new BsamVbsRecordReader(bsam) : new BsamVRecordReader(bsam);
        } else {
            throw new IllegalArgumentException("Record format is not supported");
        }
        return reader;
    }

    public synchronized int read(byte[] buf) throws ZFileException {
        return this.read(buf, 0, buf.length);
    }

    public synchronized int read(byte[] buf, int offset, int len) throws ZFileException {
        int nRead = this.bsam.readBlock(buf, offset, len);
        if (nRead != -1 && (this.bsam.getRecfmBits() & 1) == 1 && nRead != this.getBlksize()) {
            throw this.bsam.newZFileException(" with fixed blksize=" + this.getBlksize() + " contains invalid record/block with length= " + nRead, 121);
        }
        return nRead;
    }

    public synchronized void close() throws ZFileException {
        this.bsam.close();
        this.doAutoFree();
    }

    public synchronized int getLrecl() {
        return this.bsam.getLrecl();
    }

    public synchronized int getBlksize() {
        return this.bsam.getBlksize();
    }

    public synchronized int getRecfmBits() {
        return this.bsam.getRecfmBits();
    }

    public synchronized String getRecfm() {
        return this.bsam.getRecfm();
    }

    public synchronized String getDDName() {
        return this.bsam.getDDName();
    }

    public synchronized String getDsn() {
        return this.bsam.getDsn();
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("(");
        if (this.bsam != null) {
            sb.append("ddname=" + this.getDDName());
            sb.append(",dsn=" + this.getDsn());
        }
        sb.append(")");
        return sb.toString();
    }
}

