/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.LongAccessor;

public class PackedDecimalAsLongField
implements LongAccessor {
    private static long[] MAX_VALUES = new long[]{0L, 9L, 999L, 99999L, 9999999L, 999999999L, 99999999999L, 9999999999999L, 999999999999999L, 99999999999999999L, 999999999999999999L};
    private static byte[] PACKED_BYTES = new byte[100];
    private int offset;
    private int length;
    private int precision;
    private boolean signed;

    public PackedDecimalAsLongField(int offset, int precision, boolean signed) {
        if (precision < 1 || precision > 18) {
            throw new IllegalArgumentException("length");
        }
        this.offset = offset;
        this.precision = precision;
        this.length = (precision + 2) / 2;
        this.signed = signed;
    }

    public int getByteLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPrecision() {
        return this.precision;
    }

    public long getLong(byte[] buffer) throws IllegalArgumentException {
        return this.getLong(buffer, 0);
    }

    public long getLong(byte[] buffer, int bufOffset) {
        int b;
        int i;
        long value = 0L;
        int ilast = i + this.length - 1;
        for (i = this.offset + bufOffset; i < ilast; ++i) {
            b = buffer[i] & 0xFF;
            value = value * 10L + (long)(b >>> 4);
            value = value * 10L + (long)(b & 0xF);
        }
        b = buffer[ilast] & 0xFF;
        value = value * 10L + (long)(b >>> 4);
        if (this.signed) {
            int sn = b & 0xF;
            if (sn < 10) {
                throw new IllegalArgumentException("packed field contains invalid sign");
            }
            if (sn == 11 || sn == 13) {
                value = 0L - value;
            }
        }
        return value;
    }

    public void putLong(long value, byte[] buffer) throws IllegalArgumentException {
        this.putLong(value, buffer, 0);
    }

    public void putLong(long value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int signNibble;
        if (value > MAX_VALUES[this.length]) {
            throw new IllegalArgumentException("value out of range");
        }
        if (this.signed) {
            if (value < 0L) {
                if (0L - value > MAX_VALUES[this.length]) {
                    throw new IllegalArgumentException("value out of range");
                }
                signNibble = 13;
                value = -value;
            } else {
                signNibble = 12;
            }
        } else {
            if (value < 0L) {
                throw new IllegalArgumentException("value out of range");
            }
            signNibble = 15;
        }
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        buffer[ilast] = (byte)(value % 10L << 4 | (long)signNibble);
        value /= 10L;
        for (int i = ilast - 1; i >= ifirst; --i) {
            buffer[i] = PACKED_BYTES[(int)(value % 100L)];
            value /= 100L;
        }
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean equals(Long aLong, long along) {
        if (aLong == null) {
            return false;
        }
        return aLong == along;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            int low = i % 10;
            int high = i / 10 % 10;
            PackedDecimalAsLongField.PACKED_BYTES[i] = (byte)((high << 4) + low);
        }
    }
}

