/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.RecordReader;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.urbancode.airplugins.AirPluginTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class DatasetWriter {
    private static final int ERR_CODE = 1;
    private static final String DEFAULT_FILE_ENCODING = "IBM-1047";
    private static final String SLASH_SLASH_PREFIX = "//";
    private static final String DD_PREFIX = "DD:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            int availableRecLen;
            String textData;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String sourceType = inputProperties.getProperty("sourceType").trim();
            String sourceValue = inputProperties.getProperty("inputText");
            String outputDataset = inputProperties.getProperty("zDataset").trim().toUpperCase();
            String allocateDataset = inputProperties.getProperty("allocateDataset").trim().toUpperCase();
            String deleteExistingDataset = inputProperties.getProperty("deleteExistingDataset").trim().toUpperCase();
            String volumeSerial = inputProperties.getProperty("volumeSerial").trim();
            String spaceUnit = inputProperties.getProperty("spaceUnit");
            String averRecUnit = inputProperties.getProperty("averRecUnit");
            int primaryQuantity = Integer.parseInt(inputProperties.getProperty("primaryQuantity").trim());
            int secondaryQuantity = Integer.parseInt(inputProperties.getProperty("secondaryQuantity").trim());
            String recordFormat = inputProperties.getProperty("recordFormat");
            int recordLength = Integer.parseInt(inputProperties.getProperty("recordLength").trim());
            int blockSize = Integer.parseInt(inputProperties.getProperty("blockSize").trim());
            boolean isAppend = inputProperties.getProperty("isAppend").equalsIgnoreCase("TRUE");
            if (DatasetWriter.isNullOrEmpty(sourceType)) {
                System.out.println(" [ERROR] Source Type cannot be null or empty");
                System.exit(1);
            }
            if (!(sourceType.equalsIgnoreCase("TEXT") || sourceType.equalsIgnoreCase("DATASET") || sourceType.equalsIgnoreCase("FILE"))) {
                System.out.println(" [ERROR] Invalid Source Type '" + sourceType + "' found. Source Type must be either TEXT or DATASET or FILE.");
                System.exit(1);
            }
            if (DatasetWriter.isNullOrEmpty(sourceValue)) {
                System.out.println(" [ERROR] Source Value cannot be null or empty");
                System.exit(1);
            }
            if (DatasetWriter.isNullOrEmpty(outputDataset)) {
                System.out.println(" [ERROR] Output Dataset name cannot be null or empty");
                System.exit(1);
            }
            outputDataset = outputDataset.startsWith("'") ? outputDataset.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)outputDataset);
            String slashQuotedOutputDataset = ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true);
            if (sourceType.equalsIgnoreCase("FILE")) {
                sourceValue = sourceValue.trim();
                textData = DatasetWriter.getUSSFileData(sourceValue);
            } else if (sourceType.equalsIgnoreCase("DATASET")) {
                if ((sourceValue = (sourceValue = sourceValue.trim()).startsWith("'") ? sourceValue.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)sourceValue)).equalsIgnoreCase(outputDataset)) {
                    System.out.println(" [ERROR] Source dataset and Output dataset are same '" + sourceValue + "'");
                    System.exit(1);
                }
                textData = DatasetWriter.getDatasetData(sourceValue);
            } else {
                textData = sourceValue;
            }
            if (allocateDataset.equals("TRUE")) {
                if (deleteExistingDataset.equals("TRUE")) {
                    if (ZFile.dsExists((String)slashQuotedOutputDataset)) {
                        System.out.println(" [INFO] Deleting existing output dataset");
                        ZFile.remove((String)slashQuotedOutputDataset);
                    } else {
                        System.out.println(" [INFO] Output Dataset does not exist");
                    }
                }
                System.out.println(" [INFO] Allocating Output Dataset with passed parameters");
                String ddName = ZFile.allocDummyDDName();
                String createDatasetAlloc = "alloc fi(" + ddName + ") da(" + outputDataset + ") dsorg(PS) lrecl(" + recordLength + ") blksize(" + blockSize + ") space(" + primaryQuantity + "," + secondaryQuantity + ") " + spaceUnit + " RECFM(" + recordFormat + ")  dir(0) reuse new catalog msg(wtp) ";
                if (!averRecUnit.equals("---")) {
                    createDatasetAlloc = createDatasetAlloc + "avgrec(" + averRecUnit + ") ";
                }
                if (!DatasetWriter.isNullOrEmpty(volumeSerial)) {
                    createDatasetAlloc = createDatasetAlloc + "vol(" + volumeSerial + ") ";
                }
                ZFile.bpxwdyn((String)createDatasetAlloc);
                if (outputDataset.contains("(")) {
                    String fileDDname = "//DD:" + ddName;
                    try {
                        ZFile zFile = new ZFile(fileDDname, "r");
                        outputDataset = zFile.getActualFilename();
                        zFile.close();
                    }
                    catch (Exception e) {
                        ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
                        e.printStackTrace();
                        System.exit(1);
                    }
                    slashQuotedOutputDataset = ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true);
                }
                ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            }
            apTool.setOutputProperty("DatasetName", outputDataset);
            apTool.storeOutputProperties();
            if (!ZFile.dsExists((String)slashQuotedOutputDataset)) {
                System.out.println(" [ERROR] Output Dataset '" + outputDataset + "' does not exist");
                System.exit(1);
            }
            ZFile zfile = new ZFile(slashQuotedOutputDataset, "rb,type=record");
            try {
                availableRecLen = zfile.getLrecl();
                if (zfile.getRecfm().startsWith("V")) {
                    availableRecLen -= 4;
                }
            }
            finally {
                zfile.close();
            }
            DatasetWriter.writeToDataset(isAppend, outputDataset, textData, availableRecLen);
            if (isAppend) {
                System.out.println(" [INFO] Data is successfully appended to output dataset " + outputDataset);
            } else {
                System.out.println(" [INFO] Data is successfully written to output dataset " + outputDataset);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToDataset(boolean isAppend, String outputDataset, String textData, int availableRecLen) throws Exception {
        RecordWriter recordWriter = null;
        try {
            String line;
            recordWriter = isAppend ? RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true), (int)8) : RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true), (int)4);
            BufferedReader bufReader = new BufferedReader(new StringReader(textData));
            int lineCount = 0;
            String platformEncoding = ZUtil.getDefaultPlatformEncoding();
            while ((line = bufReader.readLine()) != null) {
                ++lineCount;
                String record = String.format("%-" + availableRecLen + "s", line.replaceAll("\\s+$", ""));
                byte[] recBuf = record.getBytes(platformEncoding);
                if (recBuf.length > availableRecLen) {
                    System.out.println(" [ERROR] Line number " + lineCount + " exceeds available record length of output dataset " + availableRecLen);
                    recordWriter.close();
                    System.exit(1);
                    continue;
                }
                recordWriter.write(recBuf, 0, recBuf.length);
            }
        }
        finally {
            if (recordWriter != null) {
                recordWriter.close();
            }
        }
    }

    private static String getUSSFileData(String sourceValue) throws Exception {
        FileInputStream fis;
        String fileData;
        File ussFile;
        String[] fileArgs = sourceValue.trim().split(",");
        String fileName = "";
        String fileEncoding = DEFAULT_FILE_ENCODING;
        if (fileArgs.length == 1) {
            fileName = fileArgs[0].trim();
        } else if (fileArgs.length == 2) {
            fileName = fileArgs[0].trim();
            fileEncoding = fileArgs[1].trim();
        } else {
            System.out.println(" [ERROR] Incorrect format found in Source value for FILE type. Valid formats are ");
            System.out.println("         <file-path> or <file-path>,<file-encoding>");
            System.exit(1);
        }
        if (!Charset.isSupported(fileEncoding)) {
            System.out.println(" [ERROR] Unsupported file encoding '" + fileEncoding + "' for file '" + fileName + "'");
            System.exit(1);
        }
        if (!(ussFile = new File(fileName)).isFile() || !ussFile.exists()) {
            System.out.println(" [ERROR] File '" + fileName + "' does not exist.");
            System.exit(1);
        }
        if (!ussFile.canRead()) {
            System.out.println(" [ERROR] User does not have READ permission to file '" + fileName + "'");
            System.exit(1);
        }
        if ((fileData = IOUtils.toString((InputStream)(fis = new FileInputStream(fileName)), (String)fileEncoding)).isEmpty()) {
            System.out.println(" [ERROR] File '" + fileName + "' is empty");
            System.exit(1);
        }
        return fileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDatasetData(String sourceValue) throws Exception {
        String slashQuotedSourceDsn = ZFile.getSlashSlashQuotedDSN((String)sourceValue, (boolean)true);
        if (!ZFile.dsExists((String)slashQuotedSourceDsn)) {
            System.out.println(" [ERROR] Source dataset '" + sourceValue + "' does not exist.");
            System.exit(1);
        }
        RecordReader reader = null;
        StringBuilder dsBuilder = new StringBuilder();
        try {
            int bytesRead;
            reader = RecordReader.newReader((String)slashQuotedSourceDsn, (int)1);
            byte[] recordBuf = new byte[reader.getLrecl()];
            while ((bytesRead = reader.read(recordBuf)) > 0) {
                String myRec = new String(recordBuf, 0, bytesRead, ZUtil.getDefaultPlatformEncoding());
                dsBuilder.append(myRec).append("\n");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        String dsData = dsBuilder.toString();
        if (dsData.isEmpty()) {
            System.out.println(" [ERROR] Source Dataset '" + sourceValue + "' is empty");
            System.exit(1);
        }
        return dsData;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

