/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.RecordReader;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.urbancode.air.plugin.command.SourceData;
import com.urbancode.airplugins.AirPluginTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class DatasetWriter {
    private static final int ERR_CODE = 1;
    private static final String DEFAULT_FILE_ENCODING = "IBM-1047";
    private static final String SLASH_SLASH_PREFIX = "//";
    private static final String DD_PREFIX = "DD:";
    private static final String TYPE_FILE = "FILE";
    private static final String TYPE_DATASET = "DATASET";
    private static final String TYPE_TEXT = "TEXT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            int availableRecLen;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String sourceType = inputProperties.getProperty("sourceType").trim().toUpperCase();
            String sourceValue = inputProperties.getProperty("inputText");
            String outputDataset = inputProperties.getProperty("zDataset").trim().toUpperCase();
            String allocateDataset = inputProperties.getProperty("allocateDataset").trim().toUpperCase();
            String deleteExistingDataset = inputProperties.getProperty("deleteExistingDataset").trim().toUpperCase();
            String volumeSerial = inputProperties.getProperty("volumeSerial").trim();
            String spaceUnit = inputProperties.getProperty("spaceUnit");
            String averRecUnit = inputProperties.getProperty("averRecUnit");
            int primaryQuantity = Integer.parseInt(inputProperties.getProperty("primaryQuantity").trim());
            int secondaryQuantity = Integer.parseInt(inputProperties.getProperty("secondaryQuantity").trim());
            String recordFormat = inputProperties.getProperty("recordFormat");
            int recordLength = Integer.parseInt(inputProperties.getProperty("recordLength").trim());
            int blockSize = Integer.parseInt(inputProperties.getProperty("blockSize").trim());
            boolean isAppend = inputProperties.getProperty("isAppend").equalsIgnoreCase("TRUE");
            if (DatasetWriter.isNullOrEmpty(sourceType)) {
                System.out.println(" [ERROR] Source Type cannot be null or empty");
                System.exit(1);
            }
            if (DatasetWriter.isNullOrEmpty(sourceValue)) {
                System.out.println(" [ERROR] Source Value cannot be null or empty");
                System.exit(1);
            }
            if (DatasetWriter.isNullOrEmpty(outputDataset)) {
                System.out.println(" [ERROR] Output Dataset name cannot be null or empty");
                System.exit(1);
            }
            outputDataset = outputDataset.startsWith("'") ? outputDataset.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)outputDataset);
            String slashQuotedOutputDataset = ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true);
            ArrayList<SourceData> sourceDataList = new ArrayList<SourceData>();
            switch (sourceType) {
                case "FILE": {
                    sourceDataList = DatasetWriter.getUSSFileDataList(sourceValue);
                    break;
                }
                case "DATASET": {
                    sourceDataList = DatasetWriter.getDatasetDataList(sourceValue, outputDataset);
                    break;
                }
                case "TEXT": {
                    sourceDataList.add(new SourceData(TYPE_TEXT, "inline text", sourceValue));
                    break;
                }
                default: {
                    System.out.println(" [ERROR] Invalid Source Type '" + sourceType + "' found. Source Type must be either TEXT or DATASET or FILE.");
                    System.exit(1);
                }
            }
            if (allocateDataset.equals("TRUE")) {
                if (deleteExistingDataset.equals("TRUE")) {
                    if (ZFile.dsExists((String)slashQuotedOutputDataset)) {
                        System.out.println(" [INFO] Deleting existing output dataset");
                        ZFile.remove((String)slashQuotedOutputDataset);
                    } else {
                        System.out.println(" [INFO] Output Dataset does not exist");
                    }
                }
                System.out.println(" [INFO] Allocating Output Dataset with passed parameters");
                String ddName = ZFile.allocDummyDDName();
                String createDatasetAlloc = "alloc fi(" + ddName + ") da(" + outputDataset + ") dsorg(PS) lrecl(" + recordLength + ") blksize(" + blockSize + ") space(" + primaryQuantity + "," + secondaryQuantity + ") " + spaceUnit + " RECFM(" + recordFormat + ")  dir(0) reuse new catalog msg(wtp) ";
                if (!averRecUnit.equals("---")) {
                    createDatasetAlloc = createDatasetAlloc + "avgrec(" + averRecUnit + ") ";
                }
                if (!DatasetWriter.isNullOrEmpty(volumeSerial)) {
                    createDatasetAlloc = createDatasetAlloc + "vol(" + volumeSerial + ") ";
                }
                ZFile.bpxwdyn((String)createDatasetAlloc);
                if (outputDataset.contains("(")) {
                    String fileDDName = "//DD:" + ddName;
                    try {
                        ZFile zFile = new ZFile(fileDDName, "r");
                        outputDataset = zFile.getActualFilename();
                        zFile.close();
                    }
                    catch (Exception e) {
                        ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
                        e.printStackTrace();
                        System.exit(1);
                    }
                    slashQuotedOutputDataset = ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true);
                }
                ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            }
            apTool.setOutputProperty("DatasetName", outputDataset);
            apTool.storeOutputProperties();
            if (!ZFile.dsExists((String)slashQuotedOutputDataset)) {
                System.out.println(" [ERROR] Output Dataset '" + outputDataset + "' does not exist");
                System.exit(1);
            }
            try (ZFile zfile = new ZFile(slashQuotedOutputDataset, "rb,type=record");){
                availableRecLen = zfile.getLrecl();
                if (zfile.getRecfm().startsWith("V")) {
                    availableRecLen -= 4;
                }
            }
            DatasetWriter.writeToDataset(isAppend, outputDataset, sourceDataList, availableRecLen);
            if (isAppend) {
                System.out.println(" [INFO] Data is successfully appended to output dataset " + outputDataset);
            } else {
                System.out.println(" [INFO] Data is successfully written to output dataset " + outputDataset);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void writeToDataset(boolean isAppend, String outputDataset, List<SourceData> sourceDataList, int availableRecLen) throws Exception {
        try (RecordWriter recordWriter = null;){
            recordWriter = isAppend ? RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true), (int)8) : RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true), (int)4);
            for (SourceData sourceData : sourceDataList) {
                String line;
                String textData = sourceData.getTextData();
                System.out.println(" [INFO] Writing data from " + sourceData.getTextSourceName());
                BufferedReader bufReader = new BufferedReader(new StringReader(textData));
                int lineCount = 0;
                String platformEncoding = ZUtil.getDefaultPlatformEncoding();
                while ((line = bufReader.readLine()) != null) {
                    ++lineCount;
                    String record = String.format("%-" + availableRecLen + "s", line.replaceAll("\\s+$", ""));
                    byte[] recBuf = record.getBytes(platformEncoding);
                    if (recBuf.length > availableRecLen) {
                        DatasetWriter.printLreclErrorMessage(sourceData, lineCount, availableRecLen);
                        recordWriter.close();
                        System.exit(1);
                        continue;
                    }
                    recordWriter.write(recBuf, 0, recBuf.length);
                }
            }
        }
    }

    private static void printLreclErrorMessage(SourceData sourceData, int lineCount, int availableRecLen) {
        switch (sourceData.getDataType()) {
            case "TEXT": {
                System.out.println(" [ERROR] Line number " + lineCount + " in source text exceeds available record length of output dataset " + availableRecLen);
                break;
            }
            case "DATASET": {
                System.out.println(" [ERROR] Line number " + lineCount + " in source dataset '" + sourceData.getTextSourceName() + "' exceeds available record length of output dataset " + availableRecLen);
                break;
            }
            case "FILE": {
                System.out.println(" [ERROR] Line number " + lineCount + " in source file '" + sourceData.getTextSourceName() + "' exceeds available record length of output dataset " + availableRecLen);
            }
        }
    }

    private static List<SourceData> getUSSFileDataList(String sourceLines) throws Exception {
        String sourceValueLine;
        BufferedReader bufReader = new BufferedReader(new StringReader(sourceLines));
        int lineNo = 0;
        ArrayList<SourceData> sourceDataList = new ArrayList<SourceData>();
        while ((sourceValueLine = bufReader.readLine()) != null) {
            FileInputStream fis;
            String fileData;
            File ussFile;
            ++lineNo;
            if (DatasetWriter.isNullOrEmpty(sourceValueLine)) continue;
            String[] fileArgs = sourceValueLine.trim().split(",");
            String fileName = "";
            String fileEncoding = DEFAULT_FILE_ENCODING;
            if (fileArgs.length == 1) {
                fileName = fileArgs[0].trim();
            } else if (fileArgs.length == 2) {
                fileName = fileArgs[0].trim();
                fileEncoding = fileArgs[1].trim();
            } else {
                System.out.println(" [ERROR] Incorrect format found in Source value for FILE type at line no " + lineNo + ". Valid formats are ");
                System.out.println("         <file-path> or <file-path>,<file-encoding>");
                System.exit(1);
            }
            if (!Charset.isSupported(fileEncoding)) {
                System.out.println(" [ERROR] Unsupported file encoding '" + fileEncoding + "' found for file '" + fileName + "' at line no " + lineNo);
                System.exit(1);
            }
            if (!(ussFile = new File(fileName)).isFile() || !ussFile.exists()) {
                System.out.println(" [ERROR] File '" + fileName + "' does not exist at line no " + lineNo);
                System.exit(1);
            }
            if (!ussFile.canRead()) {
                System.out.println(" [ERROR] User does not have READ permission to file '" + fileName + "' at line no " + lineNo);
                System.exit(1);
            }
            if ((fileData = IOUtils.toString((InputStream)(fis = new FileInputStream(fileName)), (String)fileEncoding)).isEmpty()) {
                System.out.println(" [ERROR] File '" + fileName + "' at line no " + lineNo + " is empty");
                System.exit(1);
            }
            sourceDataList.add(new SourceData(TYPE_FILE, fileName, fileData));
        }
        return sourceDataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<SourceData> getDatasetDataList(String sourceLines, String outputDataset) throws Exception {
        String sourceValueLine;
        BufferedReader bufReader = new BufferedReader(new StringReader(sourceLines));
        int lineNo = 0;
        ArrayList<SourceData> sourceDataList = new ArrayList<SourceData>();
        while ((sourceValueLine = bufReader.readLine()) != null) {
            String slashQuotedSourceDsn;
            ++lineNo;
            if (DatasetWriter.isNullOrEmpty(sourceValueLine)) continue;
            if ((sourceValueLine = (sourceValueLine = sourceValueLine.trim()).startsWith("'") ? sourceValueLine.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)sourceValueLine)).equalsIgnoreCase(outputDataset)) {
                System.out.println(" [ERROR] Source dataset and Output dataset are same '" + sourceValueLine + "' at line no " + lineNo);
                System.exit(1);
            }
            if (!ZFile.dsExists((String)(slashQuotedSourceDsn = ZFile.getSlashSlashQuotedDSN((String)sourceValueLine, (boolean)true)))) {
                System.out.println(" [ERROR] Source dataset '" + sourceValueLine + "' at line no " + lineNo + " does not exist.");
                System.exit(1);
            }
            StringBuilder dsBuilder = new StringBuilder();
            try (RecordReader reader = null;){
                int bytesRead;
                reader = RecordReader.newReader((String)slashQuotedSourceDsn, (int)1);
                byte[] recordBuf = new byte[reader.getLrecl()];
                while ((bytesRead = reader.read(recordBuf)) > 0) {
                    String myRec = new String(recordBuf, 0, bytesRead, ZUtil.getDefaultPlatformEncoding());
                    dsBuilder.append(myRec).append("\n");
                }
            }
            String dsData = dsBuilder.toString();
            if (dsData.isEmpty()) {
                System.out.println(" [ERROR] Source Dataset '" + sourceValueLine + "' at line no " + lineNo + " is empty");
                System.exit(1);
            }
            sourceDataList.add(new SourceData(TYPE_DATASET, sourceValueLine, dsData));
        }
        return sourceDataList;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

