/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.Messages;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZFileRecordReader;

class ZFileVariableRecordReader
extends ZFileRecordReader {
    protected int maxRecLen;
    protected byte[] block;
    protected int currentBlockLength;
    protected int currentOffset;
    public static final int RDW_LEN = 4;

    ZFileVariableRecordReader(ZFile zFile) throws ZFileException {
        super(zFile);
        this.maxRecLen = zFile.getLrecl() - 4;
        this.block = new byte[zFile.getBlksize()];
        this.currentOffset = 0;
        this.currentBlockLength = 0;
        zFile.reopen(this.mutateOptionsToRecfmU(zFile.getOptions()));
    }

    public int read(byte[] buf) throws ZFileException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws ZFileException {
        int remainingBlockLen = this.currentBlockLength - this.currentOffset;
        if (remainingBlockLen <= 0 && !this.readNextBlock()) {
            return -1;
        }
        remainingBlockLen = this.currentBlockLength - this.currentOffset;
        if (remainingBlockLen < 4) {
            this.throwInvalidPartialRdwException();
        }
        int recLen = ByteUtil.bytesAsInt(this.block, this.currentOffset, 2);
        if ((recLen -= 4) < 0 || recLen > this.maxRecLen || recLen > remainingBlockLen - 4) {
            this.throwInvalidRdwException(recLen + 4);
        }
        this.currentOffset += 4;
        if (len > recLen) {
            len = recLen;
        }
        System.arraycopy(this.block, this.currentOffset, buf, offset, len);
        this.currentOffset += recLen;
        return len;
    }

    protected boolean readNextBlock() throws ZFileException {
        int bdwLen;
        this.currentOffset = 0;
        this.currentBlockLength = this.zFile.read(this.block);
        if (this.currentBlockLength == -1) {
            return false;
        }
        if (this.currentBlockLength < 4) {
            this.throwInvalidBlockLengthException(this.currentBlockLength);
        }
        if ((bdwLen = ByteUtil.bytesAsInt(this.block, 0, 2)) < 0 || bdwLen > this.currentBlockLength) {
            this.throwInvalidBdwException(bdwLen, this.currentBlockLength);
        }
        this.currentBlockLength = bdwLen;
        this.currentOffset = 4;
        return true;
    }

    protected void throwInvalidBlockLengthException(int blockLen) throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableRecordReader.ContainsInvalidBlockLen") + blockLen, -1);
    }

    protected void throwInvalidBdwException(int bdwLen, int blockLen) throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableRecordReader.ContainsInvalidBDW") + bdwLen + Messages.getString("ZFileVariableRecordReader.WIthBlockLen") + blockLen, -1);
    }

    protected void throwInvalidRdwException(int recLen) throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableRecordReader.AtOffset") + this.currentOffset + Messages.getString("ZFileVariableRecordReader.ContainsInvalidRDW") + recLen, -1);
    }

    protected void throwInvalidPartialRdwException() throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableRecordReader.AtOffset") + this.currentOffset + Messages.getString("ZFileVariableRecordReader.ContainsInvalidPartialRDW"), -1);
    }
}

