/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.urbancode.air.plugin.command.WriteHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.util.Properties;
import java.util.regex.Pattern;

public class DatasetWriter {
    private static final int ERR_CODE = 1;
    private static final String SLASH_SLASH_PREFIX = "//";
    private static final String DD_PREFIX = "DD:";
    private static String outputDataset;
    private static String deleteExistingDataset;
    private static String volumeSerial;
    private static String spaceUnit;
    private static String averRecUnit;
    private static int primaryQuantity;
    private static int secondaryQuantity;
    private static String recordFormat;
    private static int recordLength;
    private static int blockSize;

    public static void main(String[] args) {
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String sourceType = inputProperties.getProperty("sourceType").trim().toUpperCase();
            String sourceValue = inputProperties.getProperty("inputText");
            outputDataset = inputProperties.getProperty("zDataset").trim().toUpperCase();
            String allocateDataset = inputProperties.getProperty("allocateDataset").trim().toUpperCase();
            deleteExistingDataset = inputProperties.getProperty("deleteExistingDataset").trim().toUpperCase();
            volumeSerial = inputProperties.getProperty("volumeSerial").trim();
            spaceUnit = inputProperties.getProperty("spaceUnit");
            averRecUnit = inputProperties.getProperty("averRecUnit");
            primaryQuantity = Integer.parseInt(inputProperties.getProperty("primaryQuantity").trim());
            secondaryQuantity = Integer.parseInt(inputProperties.getProperty("secondaryQuantity").trim());
            recordFormat = inputProperties.getProperty("recordFormat");
            recordLength = Integer.parseInt(inputProperties.getProperty("recordLength").trim());
            blockSize = Integer.parseInt(inputProperties.getProperty("blockSize").trim());
            boolean isAppend = inputProperties.getProperty("isAppend").equalsIgnoreCase("TRUE");
            if (DatasetWriter.isNullOrEmpty(sourceType)) {
                System.out.println(" [ERROR] Source Type cannot be null or empty");
                System.exit(1);
            }
            if (DatasetWriter.isNullOrEmpty(sourceValue)) {
                System.out.println(" [ERROR] Source Value cannot be null or empty");
                System.exit(1);
            }
            if (DatasetWriter.isNullOrEmpty(outputDataset)) {
                System.out.println(" [ERROR] Output Dataset name cannot be null or empty");
                System.exit(1);
            }
            outputDataset = outputDataset.startsWith("'") ? outputDataset.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)outputDataset);
            if (allocateDataset.equals("TRUE")) {
                DatasetWriter.allocateOutputDataset();
            }
            apTool.setOutputProperty("DatasetName", outputDataset);
            apTool.storeOutputProperties();
            WriteHelper writeHelper = new WriteHelper(isAppend, outputDataset, sourceType, sourceValue);
            writeHelper.executeWriteOperation();
            if (isAppend) {
                System.out.println(" [INFO] Data is successfully appended to output dataset " + outputDataset);
            } else {
                System.out.println(" [INFO] Data is successfully written to output dataset " + outputDataset);
            }
            System.exit(0);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        catch (ZFileException zfe) {
            if (zfe.getErrno() == 92 && zfe.getErrorCode() == 152240184) {
                System.out.println(" [ERROR] User do not have permissions for dataset " + zfe.getFileName());
                System.out.println(zfe.getMessage());
            } else {
                zfe.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private static void allocateOutputDataset() throws ZFileException {
        String slashQuotedOutputDataset = ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true);
        if (deleteExistingDataset.equals("TRUE")) {
            if (ZFile.dsExists((String)slashQuotedOutputDataset)) {
                System.out.println(" [INFO] Deleting existing output dataset");
                ZFile.remove((String)slashQuotedOutputDataset);
            } else {
                System.out.println(" [INFO] Output Dataset does not exist");
            }
        }
        System.out.println(" [INFO] Allocating Output Dataset with passed parameters");
        String ddName = ZFile.allocDummyDDName();
        String createDatasetAlloc = "alloc fi(" + ddName + ") da(" + outputDataset + ") dsorg(PS) lrecl(" + recordLength + ") blksize(" + blockSize + ") space(" + primaryQuantity + "," + secondaryQuantity + ") " + spaceUnit + " RECFM(" + recordFormat + ")  dir(0) reuse new catalog msg(wtp) ";
        if (!averRecUnit.equals("---")) {
            createDatasetAlloc = createDatasetAlloc + "avgrec(" + averRecUnit + ") ";
        }
        if (!DatasetWriter.isNullOrEmpty(volumeSerial)) {
            createDatasetAlloc = createDatasetAlloc + "vol(" + volumeSerial + ") ";
        }
        ZFile.bpxwdyn((String)createDatasetAlloc);
        if (Pattern.matches(".*\\([+-]?\\d*\\).*", outputDataset)) {
            String fileDDName = "//DD:" + ddName;
            try {
                ZFile zFile = new ZFile(fileDDName, "r");
                outputDataset = zFile.getActualFilename();
                zFile.close();
            }
            catch (ZFileException e) {
                ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
                e.printStackTrace();
                System.exit(1);
            }
        }
        ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

