/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.RecordReader;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.urbancode.air.plugin.command.SourceType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class WriteHelper {
    private static final String DEFAULT_FILE_ENCODING = "IBM-1047";
    private final boolean isAppend;
    private final String outputDataset;
    private final SourceType sourceType;
    private final String sourceValue;
    private RecordWriter recordWriter = null;
    private int availableRecLen;

    public WriteHelper(boolean isAppend, String outputDataset, SourceType sourceType, String sourceValue) {
        this.isAppend = isAppend;
        this.outputDataset = outputDataset;
        this.sourceType = sourceType;
        this.sourceValue = sourceValue;
    }

    public void executeWriteOperation() throws Exception {
        try {
            this.validateAndSetOutputDsLrecl();
            this.recordWriter = this.isAppend ? RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)this.outputDataset, (boolean)true), (int)8) : RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)this.outputDataset, (boolean)true), (int)4);
            if (this.sourceType == SourceType.FILE) {
                this.writeFromFiles();
            } else if (this.sourceType == SourceType.DATASET) {
                this.writeFromDataset();
            } else {
                this.writeToOutputDataset(this.sourceValue, "inline text");
            }
        }
        finally {
            if (this.recordWriter != null) {
                this.recordWriter.close();
            }
        }
    }

    private void validateAndSetOutputDsLrecl() throws Exception {
        String slashQuotedOutputDataset = ZFile.getSlashSlashQuotedDSN((String)this.outputDataset, (boolean)true);
        if (!ZFile.dsExists((String)slashQuotedOutputDataset)) {
            throw new IllegalArgumentException(" [ERROR] Output Dataset '" + this.outputDataset + "' does not exist");
        }
        try (ZFile zfile = new ZFile(slashQuotedOutputDataset, "rb,type=record");){
            this.availableRecLen = zfile.getLrecl();
            if (zfile.getRecfm().startsWith("V")) {
                this.availableRecLen -= 4;
            }
        }
    }

    private void writeFromFiles() throws Exception {
        String sourceValueLine;
        BufferedReader bufReader = new BufferedReader(new StringReader(this.sourceValue));
        int lineNo = 0;
        while ((sourceValueLine = bufReader.readLine()) != null) {
            String fileName;
            ++lineNo;
            if (this.isNullOrEmpty(sourceValueLine)) continue;
            String[] fileArgs = sourceValueLine.trim().split(",");
            String fileEncoding = DEFAULT_FILE_ENCODING;
            if (fileArgs.length == 1) {
                fileName = fileArgs[0].trim();
            } else if (fileArgs.length == 2) {
                fileName = fileArgs[0].trim();
                fileEncoding = fileArgs[1].trim();
            } else {
                throw new IllegalArgumentException(" [ERROR] Incorrect format found in Source value for FILE type at line no " + lineNo + ". Valid formats are \n         <file-path> or <file-path>,<file-encoding>");
            }
            if (!Charset.isSupported(fileEncoding)) {
                throw new IllegalArgumentException(" [ERROR] Unsupported file encoding '" + fileEncoding + "' found for file '" + fileName + "' at line no " + lineNo);
            }
            File ussFile = new File(fileName);
            if (!ussFile.isFile() || !ussFile.exists()) {
                throw new IllegalArgumentException(" [ERROR] File '" + fileName + "' does not exist at line no " + lineNo);
            }
            if (!ussFile.canRead()) {
                throw new IllegalArgumentException(" [ERROR] User does not have READ permission to file '" + fileName + "' at line no " + lineNo);
            }
            FileInputStream fis = new FileInputStream(fileName);
            String fileData = IOUtils.toString((InputStream)fis, (String)fileEncoding);
            if (fileData.isEmpty()) {
                throw new IllegalArgumentException(" [ERROR] File '" + fileName + "' at line no " + lineNo + " is empty");
            }
            this.writeToOutputDataset(fileData, fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFromDataset() throws Exception {
        String sourceValueLine;
        BufferedReader bufReader = new BufferedReader(new StringReader(this.sourceValue));
        int lineNo = 0;
        while ((sourceValueLine = bufReader.readLine()) != null) {
            ++lineNo;
            if (this.isNullOrEmpty(sourceValueLine)) continue;
            if ((sourceValueLine = (sourceValueLine = sourceValueLine.trim()).startsWith("'") ? sourceValueLine.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)sourceValueLine)).equalsIgnoreCase(this.outputDataset)) {
                throw new IllegalArgumentException(" [ERROR] Source dataset and Output dataset are same '" + sourceValueLine + "' at line no " + lineNo);
            }
            String slashQuotedSourceDsn = ZFile.getSlashSlashQuotedDSN((String)sourceValueLine, (boolean)true);
            if (!ZFile.dsExists((String)slashQuotedSourceDsn)) {
                throw new IllegalArgumentException(" [ERROR] Source dataset '" + sourceValueLine + "' at line no " + lineNo + " does not exist.");
            }
            StringBuilder dsBuilder = new StringBuilder();
            try (RecordReader reader = null;){
                int bytesRead;
                reader = RecordReader.newReader((String)slashQuotedSourceDsn, (int)1);
                byte[] recordBuf = new byte[reader.getLrecl()];
                while ((bytesRead = reader.read(recordBuf)) > 0) {
                    String myRec = new String(recordBuf, 0, bytesRead, ZUtil.getDefaultPlatformEncoding());
                    dsBuilder.append(myRec).append("\n");
                }
            }
            String dsData = dsBuilder.toString();
            if (dsData.isEmpty()) {
                throw new IllegalArgumentException(" [ERROR] Source Dataset '" + sourceValueLine + "' at line no " + lineNo + " is empty");
            }
            this.writeToOutputDataset(dsData, sourceValueLine);
        }
    }

    private void writeToOutputDataset(String textData, String sourceName) throws Exception {
        String line;
        System.out.println(" [INFO] Writing data from " + sourceName);
        BufferedReader bufReader = new BufferedReader(new StringReader(textData));
        int lineCount = 0;
        String platformEncoding = ZUtil.getDefaultPlatformEncoding();
        while ((line = bufReader.readLine()) != null) {
            ++lineCount;
            String record = String.format("%-" + this.availableRecLen + "s", line.replaceAll("\\s+$", ""));
            byte[] recBuf = record.getBytes(platformEncoding);
            if (recBuf.length > this.availableRecLen) {
                this.printLreclErrorMessage(sourceName, lineCount);
                continue;
            }
            this.recordWriter.write(recBuf, 0, recBuf.length);
        }
    }

    private void printLreclErrorMessage(String sourceName, int lineCount) {
        if (this.sourceType == SourceType.TEXT) {
            throw new IllegalArgumentException(" [ERROR] Line number " + lineCount + " in source text exceeds available record length of output dataset " + this.availableRecLen);
        }
        if (this.sourceType == SourceType.DATASET) {
            throw new IllegalArgumentException(" [ERROR] Line number " + lineCount + " in source dataset '" + sourceName + "' exceeds available record length of output dataset " + this.availableRecLen);
        }
        throw new IllegalArgumentException(" [ERROR] Line number " + lineCount + " in source file '" + sourceName + "' exceeds available record length of output dataset " + this.availableRecLen);
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

