/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ErrnoException;
import com.ibm.jzos.Messages;
import com.ibm.jzos.MvsCommandCallback;
import com.ibm.jzos.MvsConsoleResult;
import com.ibm.jzos.RcException;
import com.ibm.jzos.WtoConstants;
import com.ibm.jzos.WtoMessage;
import com.ibm.jzos.ZUtil;

public class MvsConsole
implements WtoConstants {
    private static final String startParameters;
    private static MvsCommandListener mvsCommandListener;

    public static String getStartParameters() {
        return startParameters;
    }

    public static boolean isListening() {
        return mvsCommandListener != null && mvsCommandListener.isAlive();
    }

    public static synchronized void startMvsCommandListener() {
        if (MvsConsole.isListening()) {
            throw new IllegalStateException(Messages.getString("MvsConsole.MvsCommandWaiterPresent"));
        }
        mvsCommandListener = new MvsCommandListener();
        mvsCommandListener.setDaemon(true);
        mvsCommandListener.start();
    }

    public static MvsCommandCallback registerMvsCommandCallback(MvsCommandCallback callback) {
        MvsCommandCallback oldCallback = null;
        if (mvsCommandListener == null || !mvsCommandListener.isAlive()) {
            throw new IllegalStateException(Messages.getString("MvsConsole.MvsCommandThreadActive"));
        }
        oldCallback = mvsCommandListener.setCallback(callback);
        return oldCallback;
    }

    public static int wto(String msg, int routcdeBitMask, int descrBitMask) throws ErrnoException {
        WtoMessage wtoMessage = new WtoMessage(msg, routcdeBitMask, descrBitMask);
        return MvsConsole.wto(wtoMessage);
    }

    public static int wto(WtoMessage wtoMessage) throws ErrnoException {
        return MvsConsole.wto(wtoMessage, ZUtil.getDefaultPlatformEncoding());
    }

    public static int wto(WtoMessage wtoMessage, String encoding) throws ErrnoException {
        MvsConsoleResult result = MvsConsole.interact(wtoMessage.getMessage(), encoding, wtoMessage.getRoutcdes(), wtoMessage.getDescrs(), wtoMessage.getFlags(), wtoMessage.getToken(), 0, null, false);
        return result.getMsgId();
    }

    public static void deleteMessage(int msgId) throws ErrnoException {
        int[] msgIds = new int[]{msgId, 0};
        MvsConsole.interact(null, null, null, null, 0L, 0, 0, msgIds, false);
    }

    public static void deleteMessages(int[] msgIds) throws ErrnoException {
        MvsConsole.interact(null, null, null, null, 0L, 0, 0, msgIds, false);
    }

    public static void deleteMessagesWithToken(int deleteToken) throws ErrnoException {
        MvsConsole.interact(null, null, null, null, 0L, 0, deleteToken, null, false);
    }

    public static MvsConsoleResult waitForCmd() throws ErrnoException {
        return MvsConsole.interact(null, null, null, null, 0L, 0, 0, null, true);
    }

    public static MvsConsoleResult interact(String msg, String encoding, int[] routcde, int[] descr, long flags, int token, int deleteToken, int[] deleteIds, boolean waitForCmd) throws ErrnoException {
        return MvsConsole.console2(msg, encoding, routcde == null ? null : MvsConsole.zeroTerminateArray(routcde), descr == null ? null : MvsConsole.zeroTerminateArray(descr), flags, token, deleteToken, deleteIds == null ? null : MvsConsole.zeroTerminateArray(deleteIds), waitForCmd);
    }

    private static native MvsConsoleResult console2(String var0, String var1, int[] var2, int[] var3, long var4, int var6, int var7, int[] var8, boolean var9) throws ErrnoException;

    private static native String retrieveStartParameters() throws RcException;

    private static int[] zeroTerminateArray(int[] array) {
        if (array == null || array.length == 0) {
            return new int[]{0};
        }
        if (array[array.length - 1] == 0) {
            return array;
        }
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = 0;
        return newArray;
    }

    static {
        ZUtil.touch();
        startParameters = MvsConsole.retrieveStartParameters();
    }

    private static class MvsCommandListener
    extends Thread {
        private static int EINTR = 120;
        private MvsCommandCallback callback;

        private MvsCommandListener() {
        }

        public MvsCommandCallback setCallback(MvsCommandCallback callback) {
            MvsCommandCallback oldCallback = callback;
            this.callback = callback;
            if (callback != null && startParameters != null) {
                callback.handleStart(startParameters);
            }
            return oldCallback;
        }

        public void run() {
            try {
                while (true) {
                    MvsConsoleResult result;
                    if ((result = MvsConsole.waitForCmd()).isStopCmd()) {
                        if (this.callback != null) {
                            if (this.callback.handleStop()) {
                                System.exit(0);
                            } else {
                                ZUtil.logDiagnostic(3, Messages.getString("MvsConsole.MvsConsoleStopCallbackNoExit"));
                            }
                        } else {
                            MvsConsole.wto(Messages.getString("MvsConsole.MvsStopCommandReceived"), 32, 16);
                            System.exit(0);
                        }
                    }
                    if (!result.isModifyCmd()) continue;
                    if (this.callback != null) {
                        ZUtil.logDiagnostic(4, Messages.getString("MvsConsole.MvsConsoleModifyCallback") + result.getModifyText());
                        this.callback.handleModify(result.getModifyText());
                        continue;
                    }
                    MvsConsole.wto(Messages.getString("MvsConsole.MvsModifyCommandReceived") + result.getModifyText(), 32, 16);
                }
            }
            catch (ErrnoException ee) {
                if (ee.getErrno() == EINTR) {
                    ZUtil.logDiagnostic(3, Messages.getString("MvsConsole.MvsCommandWaiterCancelled"));
                }
                throw new RuntimeException(ee);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

