/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.SourceType;
import com.urbancode.air.plugin.command.WriteHelper;
import java.util.Properties;
import java.util.regex.Pattern;

public class DatasetWriter {
    private static final int ERR_CODE = 1;
    private static final String SLASH_SLASH_PREFIX = "//";
    private static final String DD_PREFIX = "DD:";
    private static String outputDataset;
    private static String deleteExistingDataset;
    private static String volumeSerial;
    private static String spaceUnit;
    private static String averRecUnit;
    private static int primaryQuantity;
    private static int secondaryQuantity;
    private static String recordFormat;
    private static int recordLength;
    private static int blockSize;
    private final Properties inputProperties;
    private final Properties outputProperties;

    public DatasetWriter(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            SourceType sourceType = SourceType.valueOf(this.inputProperties.getProperty("sourceType").trim().toUpperCase());
            String sourceValue = this.inputProperties.getProperty("inputText");
            outputDataset = this.inputProperties.getProperty("zDataset").trim().toUpperCase();
            String allocateDataset = this.inputProperties.getProperty("allocateDataset").trim().toUpperCase();
            deleteExistingDataset = this.inputProperties.getProperty("deleteExistingDataset").trim().toUpperCase();
            volumeSerial = this.inputProperties.getProperty("volumeSerial").trim();
            spaceUnit = this.inputProperties.getProperty("spaceUnit");
            averRecUnit = this.inputProperties.getProperty("averRecUnit");
            primaryQuantity = Integer.parseInt(this.inputProperties.getProperty("primaryQuantity").trim());
            secondaryQuantity = Integer.parseInt(this.inputProperties.getProperty("secondaryQuantity").trim());
            recordFormat = this.inputProperties.getProperty("recordFormat");
            recordLength = Integer.parseInt(this.inputProperties.getProperty("recordLength").trim());
            blockSize = Integer.parseInt(this.inputProperties.getProperty("blockSize").trim());
            boolean isAppend = this.inputProperties.getProperty("isAppend").equalsIgnoreCase("TRUE");
            if (DatasetWriter.isNullOrEmpty(sourceValue)) {
                throw new MissingInputException(" [ERROR] Source Value cannot be null or empty");
            }
            if (DatasetWriter.isNullOrEmpty(outputDataset)) {
                throw new MissingInputException(" [ERROR] Output Dataset name cannot be null or empty");
            }
            outputDataset = outputDataset.startsWith("'") ? outputDataset.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)outputDataset);
            if (allocateDataset.equals("TRUE")) {
                DatasetWriter.allocateOutputDataset();
            }
            this.outputProperties.setProperty("DatasetName", outputDataset);
            WriteHelper writeHelper = new WriteHelper(isAppend, outputDataset, sourceType, sourceValue);
            writeHelper.executeWriteOperation();
            if (isAppend) {
                System.out.println(" [INFO] Data is successfully appended to output dataset " + outputDataset);
            } else {
                System.out.println(" [INFO] Data is successfully written to output dataset " + outputDataset);
            }
            return 0;
        }
        catch (MissingInputException | IllegalArgumentException knownRuntimeException) {
            System.out.println(knownRuntimeException.getMessage());
        }
        catch (ZFileException zfe) {
            if (zfe.getErrno() == 92 && zfe.getErrorCode() == 152240184) {
                System.out.println(" [ERROR] User do not have permissions for dataset " + zfe.getFileName());
                System.out.println(zfe.getMessage());
            } else {
                zfe.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void allocateOutputDataset() throws ZFileException {
        String slashQuotedOutputDataset = ZFile.getSlashSlashQuotedDSN((String)outputDataset, (boolean)true);
        if (deleteExistingDataset.equals("TRUE")) {
            if (ZFile.dsExists((String)slashQuotedOutputDataset)) {
                System.out.println(" [INFO] Deleting existing output dataset");
                ZFile.remove((String)slashQuotedOutputDataset);
            } else {
                System.out.println(" [INFO] Output Dataset does not exist");
            }
        }
        System.out.println(" [INFO] Allocating Output Dataset with passed parameters");
        String ddName = ZFile.allocDummyDDName();
        String createDatasetAlloc = "alloc fi(" + ddName + ") da(" + outputDataset + ") dsorg(PS) lrecl(" + recordLength + ") blksize(" + blockSize + ") space(" + primaryQuantity + "," + secondaryQuantity + ") " + spaceUnit + " RECFM(" + recordFormat + ")  dir(0) reuse new catalog msg(wtp) ";
        if (!averRecUnit.equals("---")) {
            createDatasetAlloc = createDatasetAlloc + "avgrec(" + averRecUnit + ") ";
        }
        if (!DatasetWriter.isNullOrEmpty(volumeSerial)) {
            createDatasetAlloc = createDatasetAlloc + "vol(" + volumeSerial + ") ";
        }
        ZFile.bpxwdyn((String)createDatasetAlloc);
        try {
            if (Pattern.matches(".*\\([+-]?\\d*\\).*", outputDataset)) {
                String fileDDName = "//DD:" + ddName;
                ZFile zFile = new ZFile(fileDDName, "r");
                outputDataset = zFile.getActualFilename();
                zFile.close();
            }
        }
        finally {
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
        }
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

