/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.JesVsamException;
import com.ibm.jzos.ZUtil;
import java.io.IOException;
import java.util.Arrays;

public class JesVsam {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final int MODE_RECORD = 4;
    public static final int MODE_BINARY = 2;
    public static final int MODE_TEXT = 1;
    private long hJVI;
    private boolean isWrite;
    private int lrecl;
    private byte[] closeRbar = new byte[8];
    private byte[] buffer;
    private int bufEnd;
    private boolean isFixedLength;
    private String ddname;

    public JesVsam(String ddname, boolean isWrite) throws IOException {
        this(ddname, isWrite, true, 16384);
    }

    public JesVsam(String ddname, boolean isWrite, boolean isFixedLength, int bufferSize) throws JesVsamException {
        this.ddname = ddname;
        this.isWrite = isWrite;
        this.hJVI = this.open(ddname, isWrite);
        this.lrecl = this.getLrecl(this.hJVI);
        if (isWrite) {
            this.isFixedLength = isFixedLength;
            this.buffer = new byte[bufferSize];
            this.bufEnd = 0;
        }
    }

    public byte[] close() throws JesVsamException {
        if (!this.isOpen()) {
            return this.closeRbar;
        }
        this.flush();
        return this.closeWithoutFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] closeWithoutFlush() throws JesVsamException {
        if (!this.isOpen()) {
            return this.closeRbar;
        }
        try {
            long rbar = this.close(this.hJVI);
            this.closeRbar = ByteUtil.longAsBytes(rbar);
        }
        finally {
            this.hJVI = 0L;
        }
        return this.closeRbar;
    }

    public boolean isOpen() {
        return this.hJVI != 0L;
    }

    public void flush() throws JesVsamException {
        this.assertOpen();
        if (this.isWrite && this.bufEnd > 0) {
            try {
                this.put(this.hJVI, this.buffer, this.bufEnd);
            }
            catch (JesVsamException je) {
                try {
                    this.closeWithoutFlush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw je;
            }
            finally {
                this.bufEnd = 0;
            }
        }
    }

    public int getLrecl() {
        return this.lrecl;
    }

    public void setLrecl(int lrecl) {
        this.lrecl = lrecl;
    }

    public long getRbar() throws JesVsamException {
        this.assertOpen();
        return this.getRbar(this.hJVI);
    }

    public String getDDName() {
        return this.ddname;
    }

    public int readBuffer(byte[] buffer, int mode) throws JesVsamException {
        long recsAndBytesRead = this.readBuffer(buffer, mode, Integer.MAX_VALUE);
        if (recsAndBytesRead < 0L) {
            return -1;
        }
        return (int)(recsAndBytesRead & Integer.MAX_VALUE);
    }

    public long readBuffer(byte[] buffer, int mode, int maxRecords) throws JesVsamException {
        this.assertOpen();
        long recsAndBytesRead = -1L;
        try {
            recsAndBytesRead = this.getBuffer(this.hJVI, buffer, mode, maxRecords);
        }
        catch (JesVsamException e) {
            try {
                this.closeWithoutFlush();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw e;
        }
        return recsAndBytesRead;
    }

    public void point(long rba) throws JesVsamException {
        this.flush();
        this.point(this.hJVI, rba);
    }

    public int advance(int numrecs, int buflen) throws JesVsamException {
        return this.advance(this.hJVI, numrecs, buflen);
    }

    public void write(byte[] record) throws JesVsamException {
        this.write(record, 0, record.length);
    }

    public void write(byte[] record, int offset, int len) throws JesVsamException {
        this.assertOpen();
        if (len > this.lrecl) {
            throw new JesVsamException(3, 4, 3, "Record length " + len + " > lrecl " + this.lrecl);
        }
        int len_prefix = this.isFixedLength ? this.lrecl : len;
        if (this.buffer.length - this.bufEnd < len_prefix + 4) {
            this.flush();
        }
        this.buffer[this.bufEnd++] = (byte)(len_prefix >>> 24 & 0xFF);
        this.buffer[this.bufEnd++] = (byte)(len_prefix >>> 16 & 0xFF);
        this.buffer[this.bufEnd++] = (byte)(len_prefix >>> 8 & 0xFF);
        this.buffer[this.bufEnd++] = (byte)(len_prefix & 0xFF);
        System.arraycopy(record, offset, this.buffer, this.bufEnd, len);
        if (this.isFixedLength && len < this.lrecl) {
            Arrays.fill(this.buffer, this.bufEnd + len, this.bufEnd + this.lrecl, (byte)64);
            this.bufEnd += this.lrecl;
        } else {
            this.bufEnd += len;
        }
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    private void assertOpen() throws JesVsamException {
        if (!this.isOpen()) {
            throw new JesVsamException(3, 4, 2, "VSAM file is not open");
        }
    }

    public static void logDiagnostic(int level, String msg) {
        try {
            JesVsam.basicLogDiagnostic(level, msg);
        }
        catch (Throwable t) {
            System.err.println(msg);
        }
    }

    private native long open(String var1, boolean var2) throws JesVsamException;

    private native long close(long var1) throws JesVsamException;

    private native void put(long var1, byte[] var3, int var4) throws JesVsamException;

    private native long getBuffer(long var1, byte[] var3, int var4, int var5) throws JesVsamException;

    private native int advance(long var1, int var3, int var4) throws JesVsamException;

    private native void point(long var1, long var3) throws JesVsamException;

    private native int getLrecl(long var1) throws JesVsamException;

    private native long getRbar(long var1) throws JesVsamException;

    public static native void setLoggingLevel(int var0);

    private static native void basicLogDiagnostic(int var0, String var1);

    static {
        ZUtil.touch();
    }
}

