/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.ZUtil;
import com.ibm.jzos.fields.Field;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class StringField
implements Field {
    private static final byte EBCDIC_SPACE = 64;
    public static final char HIGH_VALUE = '\u009f';
    public static final String DEFAULT_ENCODING = "Cp1047";
    private int offset;
    private int length;
    private boolean trim;
    private boolean padLeft;
    private boolean allowTruncation;
    private String encoding;

    public StringField(int offset, int length) {
        this(offset, length, true);
    }

    public StringField(int offset, int length, boolean trim) {
        this(offset, length, trim, false);
    }

    public StringField(int offset, int length, boolean trim, boolean padLeft) {
        this(offset, length, trim, padLeft, true);
    }

    public StringField(int offset, int length, boolean trim, boolean padLeft, boolean allowTruncation) {
        this(offset, length, trim, padLeft, allowTruncation, DEFAULT_ENCODING);
    }

    public StringField(int offset, int length, boolean trim, boolean padLeft, boolean allowTruncation, String encoding) {
        this.offset = offset;
        this.length = length;
        this.trim = trim;
        this.padLeft = padLeft;
        this.allowTruncation = allowTruncation;
        this.setEncoding(encoding);
    }

    public static String makeString(int len, char ch) {
        char[] charray = new char[len];
        Arrays.fill(charray, ch);
        return new String(charray);
    }

    public int getByteLength() {
        return this.length;
    }

    public void setByteLength(int len) {
        this.length = len;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getString(byte[] bytes) {
        return this.getString(bytes, 0);
    }

    public String getString(byte[] bytes, int bufOffset) {
        int start = bufOffset + this.offset;
        int len = this.length;
        if (this.trim) {
            if (this.padLeft) {
                while (bytes[start] == 64 || bytes[start] == 0) {
                    ++start;
                    --len;
                }
            } else {
                int i = start + this.length - 1;
                while (i >= start && (bytes[i] == 64 || bytes[start] == 0)) {
                    --i;
                    --len;
                }
            }
        }
        String string = null;
        try {
            string = new String(bytes, start, len, this.getEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unsupported encoding", uee);
        }
        return string;
    }

    public void putString(String string, byte[] bytes) {
        this.putString(string, bytes, 0);
    }

    public void putString(String string, byte[] bytes, int bufOffset) {
        int start = bufOffset + this.offset;
        byte[] sourceBytes = null;
        try {
            sourceBytes = string.getBytes(this.getEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unsupported encoding", uee);
        }
        if (!this.allowTruncation && sourceBytes.length > this.length) {
            throw new IllegalArgumentException("String too long");
        }
        int padLength = this.length - sourceBytes.length;
        if (padLength > 0) {
            int to;
            int from;
            if (this.padLeft) {
                from = start;
                start = to = start + padLength;
            } else {
                from = start + this.length - padLength;
                to = start + this.length;
            }
            for (int i = from; i < to; ++i) {
                bytes[i] = 64;
            }
        } else if (padLength < 0) {
            padLength = 0;
        }
        System.arraycopy(sourceBytes, 0, bytes, start, this.length - padLength);
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = System.getProperty("jzos.fields.string.encoding");
            if (this.encoding == null) {
                this.encoding = "z/OS".equalsIgnoreCase(System.getProperty("os.name")) ? this.getDefaultPlatformEncoding() : DEFAULT_ENCODING;
            }
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            this.encoding = DEFAULT_ENCODING;
        } else {
            try {
                if (64 != " ".getBytes(encoding)[0]) {
                    throw new IllegalArgumentException("Encoding must be an EBCDIC variant");
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("Unsupported encoding", uee);
            }
            this.encoding = encoding;
        }
    }

    private String getDefaultPlatformEncoding() {
        return ZUtil.getDefaultPlatformEncoding();
    }

    public boolean isAllowTruncation() {
        return this.allowTruncation;
    }

    public void setAllowTruncation(boolean allowTruncation) {
        this.allowTruncation = allowTruncation;
    }

    public boolean isPadLeft() {
        return this.padLeft;
    }

    public void setPadLeft(boolean padLeft) {
        this.padLeft = padLeft;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean equals(String aString1, String aString2) {
        if (aString1 == aString2) {
            return true;
        }
        if (aString1 == null) {
            return false;
        }
        return aString1.equals(aString2);
    }
}

