/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.dataset;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.ZUtil;
import com.ibm.team.enterprise.automation.dataset.DatasetInfoException;
import com.ibm.team.enterprise.automation.dataset.DscbInfo;

public class DatasetInfo {
    private static final int FB = 144;
    private static final int VB = 80;
    private static final int U = 192;
    private static final int FBA = 148;
    private static final int VBA = 84;
    private static final byte IS = -128;
    private static final byte PS = 64;
    private static final byte DA = 32;
    private static final byte PO = 2;
    private static final String ENTNAME = "ENTNAME";
    private static final String VOLSER = "VOLSER";
    private static final String AMPERSAND_CHAR = "&";
    private static final String ASTERISK_CHAR = "*";
    private static final String PERCENT_CHAR = "%";
    private int recordLength;
    private String recFM;
    private String dsOrg;
    private int blockSize;
    private boolean isPDSE;
    private final String dsnName;

    private DatasetInfo(String dsnName) {
        this.dsnName = dsnName.toUpperCase();
    }

    public static DatasetInfo from(String dsnName) {
        DatasetInfo datasetInfo = new DatasetInfo(dsnName);
        datasetInfo.setDatasetInfo();
        return datasetInfo;
    }

    private void setDatasetInfo() {
        String volser = this.getDatasetVolserFromCatalog(this.dsnName);
        DscbInfo dscbInfo = DscbInfo.from(this.dsnName, volser);
        this.isPDSE = this.isPDSEDataset(dscbInfo.getSmsFlagInteger());
        this.recFM = this.determineRecordFormat(dscbInfo.getRecordFormatInteger());
        this.dsOrg = this.determineDsOrg(dscbInfo.getDsOrgInteger());
        this.recordLength = dscbInfo.getRecordLength();
        this.blockSize = dscbInfo.getBlockSize();
    }

    private String determineDsOrg(int dsOrgInteger) {
        byte[] dsOrgBytes = new byte[]{(byte)dsOrgInteger, (byte)(dsOrgInteger >>> 8)};
        switch (dsOrgBytes[1]) {
            case -128: {
                return "IS";
            }
            case 64: {
                return "PS";
            }
            case 32: {
                return "DA";
            }
            case 2: {
                return "PO";
            }
        }
        throw new DatasetInfoException("Unsupported dataset organization for dataset " + this.dsnName + ". Reason Code: " + dsOrgInteger);
    }

    private boolean isPDSEDataset(int smsFlagInteger) {
        byte smsFlag = (byte)smsFlagInteger;
        int intPDSE = smsFlag >> 3 & 1;
        return intPDSE == 1;
    }

    private String determineRecordFormat(int recordFormatInteger) {
        switch (recordFormatInteger) {
            case 144: {
                return "F,B";
            }
            case 80: {
                return "V,B";
            }
            case 192: {
                return "U";
            }
            case 148: {
                return "F,B,A";
            }
            case 84: {
                return "V,B,A";
            }
        }
        throw new DatasetInfoException("Unsupported record format for dataset " + this.dsnName + ". Reason Code: " + recordFormatInteger);
    }

    private String getDatasetVolserFromCatalog(String dsnName) {
        if (dsnName.contains(ASTERISK_CHAR) || dsnName.contains(PERCENT_CHAR)) {
            throw new DatasetInfoException("Dataset name " + dsnName + " contains wildcard character '*' or '%'");
        }
        CatalogSearch catalogSearch = new CatalogSearch(dsnName);
        catalogSearch.addFieldName(ENTNAME);
        catalogSearch.addFieldName(VOLSER);
        catalogSearch.search();
        while (catalogSearch.hasNext()) {
            CatalogSearch.Entry entry = (CatalogSearch.Entry)catalogSearch.next();
            if (!entry.isDatasetEntry() || !this.isDsnNameMatchedWithEntryField(dsnName, entry)) continue;
            return this.getVolser(entry);
        }
        throw new DatasetInfoException("Dataset " + dsnName + " not found in catalog.");
    }

    private boolean isDsnNameMatchedWithEntryField(String dsnName, CatalogSearch.Entry entry) {
        String entryField = entry.getField(ENTNAME).getFString().trim();
        return entryField.equals(dsnName);
    }

    private String getVolser(CatalogSearch.Entry entry) {
        String volser = entry.getField(VOLSER).getFString().trim();
        if (volser.contains(AMPERSAND_CHAR)) {
            volser = ZUtil.substituteSystemSymbols((String)volser, (boolean)true);
        }
        return volser;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public String getRecFM() {
        return this.recFM;
    }

    public String getDsOrg() {
        return this.dsOrg;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isPDSE() {
        return this.isPDSE;
    }
}

