/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.dataset.record;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetLreclException;
import java.io.IOException;
import java.util.List;

public final class DatasetRecordsWriter {
    public static final int DATASET_LRECL = 144;

    private DatasetRecordsWriter() {
    }

    public static void write(List<DatasetRecord> datasetRecords, String dataset) throws IOException {
        DatasetRecordsWriter.createDataset(dataset);
        DatasetRecordsWriter.loadRecordsIntoDataset(datasetRecords, dataset);
    }

    private static void createDataset(String dataset) {
        String fullyQualifiedDsn = ZFile.getFullyQualifiedDSN((String)dataset, (boolean)true);
        String targetDD = ZFile.allocDummyDDName();
        String command = "alloc fi(" + targetDD + ") da(" + fullyQualifiedDsn + ") reuse new dsorg(ps) lrecl(" + 144 + ") recfm(f,b) CYL space(1,1) blksize(" + 1440 + ") catalog msg(wtp)";
        DatasetHelper.allocateDataset(command);
        ZFile.bpxwdyn((String)("free fi(" + targetDD + ") msg(wtp)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRecordsIntoDataset(List<DatasetRecord> datasetRecords, String dataset) throws IOException {
        RecordWriter writer = RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)dataset, (boolean)true), (int)1);
        try {
            for (DatasetRecord datasetRecord : datasetRecords) {
                DatasetRecordsWriter.writeRecord(writer, datasetRecord.getRecord());
            }
        }
        finally {
            writer.close();
            writer.flush();
        }
    }

    private static void writeRecord(RecordWriter writer, String record) throws IOException {
        if (record.length() > 144) {
            throw new DatasetLreclException("Action record exceeds record length 144");
        }
        String formattedLine = String.format("%-144s", record);
        byte[] bytes = formattedLine.getBytes(ZUtil.getDefaultPlatformEncoding());
        writer.write(bytes, 0, bytes.length);
    }
}

