/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.urbancode.zos.common.util.Console;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ProcessExecutor {
    private static final String ENCODING_IBM_1047 = "IBM-1047";

    public static int runProcess(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        Process process = processBuilder.start();
        ProcessExecutor.printProcessStreams(process);
        return process.waitFor();
    }

    private static void printProcessStreams(Process process) throws IOException {
        try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), ENCODING_IBM_1047));){
            ProcessExecutor.printStream(stdInput);
        }
        var2_2 = null;
        try (BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream(), ENCODING_IBM_1047));){
            ProcessExecutor.printStream(stdError);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private static void printStream(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            Console.printProcessOutput(line);
        }
    }
}

