/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.alloc;

import com.ibm.urbancode.zos.dataset.alloc.AllocCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;

public class AllocGenericCommandBuilder
implements AllocCommandBuilder {
    private String allocCommand = "";
    private final String datasetName;

    public AllocGenericCommandBuilder(String datasetName) {
        this.datasetName = datasetName;
    }

    public AllocGenericCommandBuilder withVolumeSerial(String volumeSerial) {
        this.allocCommand = this.allocCommand + (volumeSerial.isEmpty() ? "" : " vol(" + volumeSerial + ")");
        return this;
    }

    public AllocGenericCommandBuilder withSpace(String primaryQuantity, String secondaryQuantity) {
        this.allocCommand = this.allocCommand + " space(" + primaryQuantity + "," + secondaryQuantity + ")";
        return this;
    }

    public AllocGenericCommandBuilder withSpaceUnit(String spaceUnit, String recordLength) {
        this.allocCommand = this.allocCommand + (spaceUnit.equals("BLKS") ? " block(" + recordLength + ")" : " " + spaceUnit);
        return this;
    }

    public AllocGenericCommandBuilder withBlockSize(String blockSize) {
        this.allocCommand = this.allocCommand + (blockSize.isEmpty() ? "" : " blksize(" + blockSize + ")");
        return this;
    }

    public AllocGenericCommandBuilder withAvgRec(String avgRec) {
        this.allocCommand = this.allocCommand + (avgRec.isEmpty() ? "" : " avgrec(" + avgRec + ")");
        return this;
    }

    public AllocGenericCommandBuilder withDirectoryBlocks(String directoryBlocks) {
        this.allocCommand = this.allocCommand + " dir(" + directoryBlocks + ")";
        return this;
    }

    public AllocGenericCommandBuilder withRecordFormat(String recordFormat) {
        this.allocCommand = this.allocCommand + " recfm(" + recordFormat + ")";
        return this;
    }

    public AllocGenericCommandBuilder withRecordLength(String recordLength) {
        this.allocCommand = this.allocCommand + " lrecl(" + recordLength + ")";
        return this;
    }

    public AllocGenericCommandBuilder withDatasetType(String dsnType) {
        this.allocCommand = this.allocCommand + (dsnType.isEmpty() ? "" : " dsntype(" + dsnType + ")");
        return this;
    }

    public AllocGenericCommandBuilder withDsOrg(String dsOrg) {
        this.allocCommand = this.allocCommand + (dsOrg.isEmpty() ? "" : " dsorg(" + dsOrg + ")");
        return this;
    }

    @Override
    public DatasetAllocator build() {
        return new DatasetAllocator(this);
    }

    @Override
    public String getAllocCommand() {
        return this.allocCommand;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }
}

