/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import java.util.Objects;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ZInventoryEntry {
    private final String name;
    private final String inputs;
    private final String operationType;
    private final String deployType;
    private final String targetType;
    private final String target;
    private final long deployTime;

    private ZInventoryEntry(String name, String inputs, String operationType, String deployType, String targetType, String target, long deployTime) {
        this.name = name;
        this.inputs = inputs;
        this.operationType = operationType;
        this.deployType = deployType;
        this.targetType = targetType;
        this.target = target;
        this.deployTime = deployTime;
    }

    public static ZInventoryEntry fromJSONObject(JSONObject obj) throws JSONException {
        if (obj.has("file_name")) {
            return ZInventoryEntry.fromRemoteJSONObject(obj);
        }
        return ZInventoryEntry.fromLocalJSONObject(obj);
    }

    private static ZInventoryEntry fromLocalJSONObject(JSONObject obj) throws JSONException {
        return new ZInventoryEntry(obj.getString("name"), obj.getString("inputs"), obj.getString("operation-type"), obj.getString("deploy-type"), obj.getString("target-type"), obj.getString("target"), obj.getLong("deploy-time"));
    }

    private static ZInventoryEntry fromRemoteJSONObject(JSONObject obj) throws JSONException {
        return new ZInventoryEntry(obj.getString("file_name"), obj.getString("inputs"), obj.getString("operation_type"), obj.getString("deploy_type"), obj.getString("target_type"), obj.getString("target"), obj.getLong("deploy_time"));
    }

    public String getName() {
        return this.name;
    }

    public String getInputs() {
        return this.inputs;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getDeployType() {
        return this.deployType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTarget() {
        return this.target;
    }

    public long getDeployTime() {
        return this.deployTime;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.target, this.targetType);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZInventoryEntry)) {
            return false;
        }
        ZInventoryEntry other = (ZInventoryEntry)o;
        return Objects.equals(other.getName(), this.name) && Objects.equals(other.getTarget(), this.target) && Objects.equals(other.getTargetType(), this.targetType);
    }
}

