/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.UdClientHelper;
import com.ibm.urbancode.zos.zinventory.ZInventoryException;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

class ZInventoryHttpService {
    private static final int SUCCESS_CODE_204 = 204;
    private static final int SUCCESS_CODE_200 = 200;
    private static final String Z_INVENTORY_BASE_PATH = "/cli/zInventory";
    private static final String ROLLBACK_PATH = "/rollback";
    private static final int NOT_FOUND_CODE = 404;
    private static final String SEARCH = "/search";

    ZInventoryHttpService() {
    }

    public static void addDeploymentDataToZInventoryTable(String requestBody) throws IOException, URISyntaxException {
        try (DefaultHttpClient httpClient = UDRestClient.createHttpClient((String)"PasswordIsAuthToken", (String)UdClientHelper.UD_PASS, (boolean)true);){
            URI uri = new URI(UdClientHelper.WEB_URL + Z_INVENTORY_BASE_PATH);
            HttpPost method = new HttpPost(uri);
            method.setEntity((HttpEntity)new StringEntity(requestBody));
            ZInventoryHttpService.invokeMethod((HttpRequestBase)method, httpClient);
        }
    }

    public static void rollbackDataInZInventoryTable(List<NameValuePair> params) throws URISyntaxException, IOException {
        try (DefaultHttpClient httpClient = UDRestClient.createHttpClient((String)"PasswordIsAuthToken", (String)UdClientHelper.UD_PASS, (boolean)true);){
            URI uri = new URIBuilder(UdClientHelper.WEB_URL + Z_INVENTORY_BASE_PATH + ROLLBACK_PATH).addParameters(params).build();
            HttpPost method = new HttpPost(uri);
            ZInventoryHttpService.invokeMethod((HttpRequestBase)method, httpClient);
        }
    }

    public static String searchDataInZInventoryTable(String requestBody) throws IOException, URISyntaxException {
        try (DefaultHttpClient httpClient = UDRestClient.createHttpClient((String)"PasswordIsAuthToken", (String)UdClientHelper.UD_PASS, (boolean)true);){
            URI uri = new URI(UdClientHelper.WEB_URL + Z_INVENTORY_BASE_PATH + SEARCH);
            HttpPost method = new HttpPost(uri);
            method.setEntity((HttpEntity)new StringEntity(requestBody));
            String string = ZInventoryHttpService.invokeSearchMethod((HttpRequestBase)method, httpClient);
            return string;
        }
    }

    private static String getBody(CloseableHttpResponse response) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStream body = response.getEntity().getContent();
        if (body != null) {
            try (InputStreamReader reader = IO.reader(body, IO.utf8());){
                IO.copy((Reader)reader, builder);
            }
        }
        return builder.toString();
    }

    private static void invokeMethod(HttpRequestBase request, DefaultHttpClient httpClient) throws IOException {
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 204) {
            Console.printProcessOutput("Added Data to Z Inventory");
        } else if (statusCode == 404) {
            System.out.println();
        } else {
            throw new ZInventoryException("Status code - " + statusCode + "\nReason phrase - " + response.getStatusLine().getReasonPhrase() + "\n" + ZInventoryHttpService.getBody(response));
        }
    }

    private static String invokeSearchMethod(HttpRequestBase request, DefaultHttpClient httpClient) throws IOException {
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return ZInventoryHttpService.getSearchOutput(response);
        }
        throw new ZInventoryException("Status code - " + statusCode + "\nReason phrase - " + response.getStatusLine().getReasonPhrase() + "\n" + ZInventoryHttpService.getBody(response));
    }

    private static String getSearchOutput(CloseableHttpResponse response) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStream body = response.getEntity().getContent();
        if (body != null) {
            try (InputStreamReader reader = IO.reader(body, IO.utf8());){
                IO.copy((Reader)reader, builder);
            }
        }
        return builder.toString();
    }
}

