/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.common.XmlIndentHandler;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class BackupManifestMvsGenerator {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private XMLStreamWriter xmlStreamWriter = null;

    private BackupManifestMvsGenerator() {
    }

    public static String generate(String packageManifestPath, String containerMapperPath) throws XMLStreamException, IOException {
        PackageManifest packageManifest = PackageManifest.from((String)packageManifestPath, (String)containerMapperPath);
        BackupManifestMvsGenerator backupManifestMvsGenerator = new BackupManifestMvsGenerator();
        return backupManifestMvsGenerator.generateXML(packageManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateXML(PackageManifest packageManifest) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements(packageManifest);
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements(PackageManifest packageManifest) throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeStartElement("manifest");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.writeContainers(packageManifest.getAddedContainers());
        this.writeDeletedContainers(packageManifest.getDeletedContainers());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeDeletedContainers(List<Container> deletedContainers) throws XMLStreamException {
        if (deletedContainers.isEmpty()) {
            return;
        }
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("deleted");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.writeContainers(deletedContainers);
        this.writeEndElement();
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeContainers(List<Container> containers) throws XMLStreamException {
        for (Container container : containers) {
            if (container.isPds()) {
                this.writePDSContainers(container);
                continue;
            }
            if (!container.isSequential()) continue;
            this.writeSequentialContainers(container);
        }
    }

    private void writeSequentialContainers(Container container) throws XMLStreamException {
        for (String targetDataset : container.getTargetContainers()) {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
            this.xmlStreamWriter.writeEmptyElement("container");
            this.xmlStreamWriter.writeAttribute("name", targetDataset);
            this.xmlStreamWriter.writeAttribute("type", "sequential");
            if (container.getDeployType() != null) {
                this.xmlStreamWriter.writeAttribute("deployType", container.getDeployType());
            }
            this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        }
    }

    private void writePDSContainers(Container container) throws XMLStreamException {
        for (String targetDataset : container.getTargetContainers()) {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
            this.xmlStreamWriter.writeStartElement("container");
            this.xmlStreamWriter.writeAttribute("name", targetDataset);
            this.xmlStreamWriter.writeAttribute("type", "PDS");
            if (container.getDeployType() != null) {
                this.xmlStreamWriter.writeAttribute("deployType", container.getDeployType());
            }
            this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
            this.writeContainerResources(container.getResources());
            this.writeEndElement();
        }
    }

    private void writeContainerResources(Collection<Resource> members) throws XMLStreamException {
        for (Resource resource : members) {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
            this.xmlStreamWriter.writeEmptyElement("resource");
            this.xmlStreamWriter.writeAttribute("name", resource.getName());
            this.xmlStreamWriter.writeAttribute("type", resource.getType());
            if (resource.getResourceDeployType() != null) {
                this.xmlStreamWriter.writeAttribute("deployType", resource.getResourceDeployType());
            }
            this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        }
    }
}

