/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.rollback;

import com.ibm.urbancode.zos.common.util.StringHelper;
import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.urbancode.air.plugin.command.version.rollback.RiskyArtifact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RiskyArtifactHelper {
    private static final String DIRECTORY_SEPARATOR = "/";

    static List<RiskyArtifact> getMvsTargetContainerResourceForRiskyArtifacts(JSONArray riskyArtifacts, Map<String, List<String>> srcTargetDatasetMapping, int ignoreHlqLength) throws JSONException {
        HashMap<String, Set<String>> riskyDatasetMemberMappingIgnoringHlq = RiskyArtifactHelper.convertOverlapArtifactsToDatasetMemberMapIgnoringHlq(riskyArtifacts, ignoreHlqLength);
        HashMap<String, List<String>> srcTargetDatasetMappingIgnoringHlq = RiskyArtifactHelper.removeHlqFromSrcTargetMap(srcTargetDatasetMapping, ignoreHlqLength);
        return RiskyArtifactHelper.generateRiskyArtifactsForMvs(riskyDatasetMemberMappingIgnoringHlq, srcTargetDatasetMappingIgnoringHlq);
    }

    static List<RiskyArtifact> getHfsTargetContainerResourceForRiskyArtifacts(JSONArray riskyArtifacts, Map<String, List<String>> srcTargetHfsMapping) throws JSONException {
        HashMap<String, Set<String>> riskyDirectoryFileMap = RiskyArtifactHelper.convertOverlapArtifactsToDirectoryFileMap(riskyArtifacts);
        return RiskyArtifactHelper.generateRiskyArtifactsForHfs(riskyDirectoryFileMap, srcTargetHfsMapping);
    }

    private static HashMap<String, List<String>> removeHlqFromSrcTargetMap(Map<String, List<String>> srcTargetDatasetMap, int ignoreHlqLength) {
        HashMap<String, List<String>> trimmedKeyValues = new HashMap<String, List<String>>();
        srcTargetDatasetMap.forEach((key, values) -> {
            String trimmedDataset = StringHelper.getDatasetNamePostIgnoringHlq(key, ignoreHlqLength);
            if (trimmedKeyValues.containsKey(trimmedDataset)) {
                ((List)trimmedKeyValues.get(trimmedDataset)).addAll(values);
            } else {
                trimmedKeyValues.put(trimmedDataset, (List<String>)values);
            }
        });
        return trimmedKeyValues;
    }

    private static List<RiskyArtifact> generateRiskyArtifactsForMvs(Map<String, Set<String>> riskyArtifactsMap, Map<String, List<String>> containerMapping) {
        ArrayList<RiskyArtifact> riskyArtifacts = new ArrayList<RiskyArtifact>();
        for (String riskyArtifactContainer : riskyArtifactsMap.keySet()) {
            if (!containerMapping.containsKey(riskyArtifactContainer)) {
                throw new IllegalArgumentException("Missing container mapping for risky artifact - " + riskyArtifactContainer);
            }
            for (String targetContainer : containerMapping.get(riskyArtifactContainer)) {
                RiskyArtifact riskyArtifact = new RiskyArtifact(targetContainer, ContainerType.PDS);
                int index = riskyArtifacts.indexOf(riskyArtifact);
                if (index == -1) {
                    Set<String> resources = riskyArtifactsMap.get(riskyArtifactContainer);
                    if (resources.isEmpty()) {
                        riskyArtifacts.add(new RiskyArtifact(targetContainer, ContainerType.SEQUENTIAL));
                        continue;
                    }
                    riskyArtifact.addResources(resources);
                    riskyArtifacts.add(riskyArtifact);
                    continue;
                }
                riskyArtifact = (RiskyArtifact)riskyArtifacts.get(index);
                riskyArtifact.addResources(riskyArtifactsMap.get(riskyArtifactContainer));
            }
        }
        return riskyArtifacts;
    }

    private static List<RiskyArtifact> generateRiskyArtifactsForHfs(Map<String, Set<String>> riskyArtifactsMap, Map<String, List<String>> containerMapping) {
        ArrayList<RiskyArtifact> riskyArtifacts = new ArrayList<RiskyArtifact>();
        for (String riskyArtifactContainer : riskyArtifactsMap.keySet()) {
            if (!containerMapping.containsKey(riskyArtifactContainer)) {
                throw new IllegalArgumentException("Missing container mapping for risky artifact - " + riskyArtifactContainer);
            }
            RiskyArtifact riskyArtifact = new RiskyArtifact(riskyArtifactContainer, ContainerType.DIRECTORY);
            riskyArtifact.addResources(riskyArtifactsMap.get(riskyArtifactContainer));
            riskyArtifacts.add(riskyArtifact);
        }
        return riskyArtifacts;
    }

    private static HashMap<String, Set<String>> convertOverlapArtifactsToDatasetMemberMapIgnoringHlq(JSONArray overlappingArtifacts, int ignoreQualifierLength) throws JSONException {
        HashMap<String, Set<String>> datasetMemberMap = new HashMap<String, Set<String>>();
        for (int i = 0; i < overlappingArtifacts.length(); ++i) {
            String member;
            JSONObject overlapArtifact = overlappingArtifacts.getJSONObject(i);
            String name = overlapArtifact.getString("name");
            if (RiskyArtifactHelper.isHfs(name)) continue;
            String datasetMemberIgnoringHlq = StringHelper.getDatasetNamePostIgnoringHlq(name, ignoreQualifierLength);
            String[] datasetMember = RiskyArtifactHelper.splitDatasetString(datasetMemberIgnoringHlq);
            String dataset = datasetMember[0];
            String string = member = datasetMember.length == 2 ? datasetMember[1] : null;
            if (!datasetMemberMap.containsKey(dataset)) {
                LinkedHashSet<String> members = new LinkedHashSet<String>();
                if (member != null) {
                    members.add(member);
                }
                datasetMemberMap.put(dataset, members);
                continue;
            }
            if (member == null) continue;
            datasetMemberMap.get(dataset).add(member);
        }
        return datasetMemberMap;
    }

    private static HashMap<String, Set<String>> convertOverlapArtifactsToDirectoryFileMap(JSONArray overlappingArtifacts) throws JSONException {
        HashMap<String, Set<String>> directoryFileMap = new HashMap<String, Set<String>>();
        for (int i = 0; i < overlappingArtifacts.length(); ++i) {
            JSONObject overlapArtifact = overlappingArtifacts.getJSONObject(i);
            String name = overlapArtifact.getString("name");
            if (!RiskyArtifactHelper.isHfs(name)) continue;
            String[] directoryFile = RiskyArtifactHelper.splitOnLastSlash(name);
            String directory = directoryFile[0];
            String file = directoryFile[1];
            if (directoryFileMap.containsKey(directory)) {
                if (file == null) continue;
                directoryFileMap.get(directory).add(file);
                continue;
            }
            LinkedHashSet<String> files = new LinkedHashSet<String>();
            if (file != null) {
                files.add(file);
            }
            directoryFileMap.put(directory, files);
        }
        return directoryFileMap;
    }

    private static String[] splitDatasetString(String datasetWithMember) {
        int start = datasetWithMember.indexOf(40);
        int end = datasetWithMember.indexOf(41);
        if (start != -1 && end != -1 && end > start) {
            String dataset = datasetWithMember.substring(0, start);
            String member = datasetWithMember.substring(start + 1, end);
            return new String[]{dataset, member};
        }
        return new String[]{datasetWithMember};
    }

    private static String[] splitOnLastSlash(String input) {
        int lastSlashIndex = input.lastIndexOf(DIRECTORY_SEPARATOR);
        String containerName = input.substring(0, lastSlashIndex);
        String fileName = input.substring(lastSlashIndex + 1);
        return new String[]{containerName, fileName};
    }

    private static boolean isHfs(String containerName) {
        return containerName.contains(DIRECTORY_SEPARATOR);
    }
}

