/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class CpDataset {
    private static final String SEQUENTIAL = "sequential";
    private final String name;
    private final Set<String> members = new LinkedHashSet<String>();
    private final String dsType;
    private final String cpOption;
    private final String deployType;

    public CpDataset(String name, String dsType, String cpOption) {
        this(name, dsType, cpOption, null);
    }

    public CpDataset(String name, String dsType, String cpOption, String deployType) {
        this.name = name;
        this.dsType = dsType;
        this.cpOption = cpOption;
        this.deployType = deployType;
    }

    public void addMember(String member) {
        if (!this.members.add(member)) {
            throw new IllegalArgumentException("Dataset " + this.name + " contains duplicate member " + member);
        }
    }

    public void addMembers(Collection<String> members) {
        members.forEach(this::addMember);
    }

    public boolean isSequentialDataset() {
        return this.dsType.equalsIgnoreCase(SEQUENTIAL);
    }

    public String getName() {
        return this.name;
    }

    public String getCpOption() {
        return this.cpOption;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public String getDsType() {
        return this.dsType;
    }

    public String getDeployType() {
        return this.deployType;
    }
}

