/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.hfs;

import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.ContainerMap;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.io.File;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Move;

public class DeployFilesTask {
    private static final Predicate<Container> DEPLOYED_CONTAINER_PREDICATE = container -> !container.isDeleted();
    private static final Predicate<Container> DELETED_CONTAINER_PREDICATE = Container::isDeleted;
    private final String artifactsDirPath;
    private final boolean isOldHfsFormat;

    public DeployFilesTask(String artifactsDirPath, boolean isOldHfsFormat) {
        this.artifactsDirPath = artifactsDirPath;
        this.isOldHfsFormat = isOldHfsFormat;
    }

    public void execute(String manifestPath, String containerMapperHfsPath, boolean deleteCurrentContents) throws Exception {
        File targetOutputsDir;
        String containerName;
        PackageManifest packageManifest = PackageManifest.from((String)manifestPath);
        List<Container> createOrUpdateContainers = this.getContainers(packageManifest, DEPLOYED_CONTAINER_PREDICATE);
        List<Container> deletedContainers = this.getContainers(packageManifest, DELETED_CONTAINER_PREDICATE);
        ContainerMap containerMap = ContainerMap.from((String)containerMapperHfsPath);
        if (deleteCurrentContents) {
            this.deleteCurrentContentsFromTargetDir(createOrUpdateContainers, containerMap);
        }
        for (Container container : deletedContainers) {
            containerName = File.separator + container.getSourceName();
            targetOutputsDir = new File((String)containerMap.getTargets(containerName).get(0));
            this.deleteFiles(container, targetOutputsDir);
        }
        for (Container container : createOrUpdateContainers) {
            containerName = File.separator + container.getSourceName();
            targetOutputsDir = new File((String)containerMap.getTargets(containerName).get(0));
            this.moveFiles(container, targetOutputsDir);
        }
    }

    private List<Container> getContainers(PackageManifest packageManifest, Predicate<Container> predicate) {
        return packageManifest.getContainers().stream().filter(Container::isDirectory).filter(predicate).collect(Collectors.toList());
    }

    private void deleteCurrentContentsFromTargetDir(List<Container> createOrUpdateContainers, ContainerMap containerMap) {
        Console.printProcessOutput("Deleting contents in Target Directory:");
        for (Container container : createOrUpdateContainers) {
            String containerName = File.separator + container.getSourceName();
            File targetDir = new File((String)containerMap.getTargets(containerName).get(0));
            if (!targetDir.isDirectory()) continue;
            this.deleteDirectory(targetDir);
        }
    }

    private void moveFiles(Container container, File targetDir) {
        for (Resource resource : container.getResources()) {
            String containerWithResource = container.getSourceName() + File.separator + resource.getName();
            File sourceFile = new File(this.artifactsDirPath, containerWithResource);
            File targetFile = this.isOldHfsFormat ? new File(targetDir, containerWithResource) : new File(targetDir, resource.getName());
            this.moveFile(sourceFile, targetFile);
        }
    }

    private void deleteFiles(Container container, File targetDir) {
        for (Resource resource : container.getResources()) {
            String containerWithResource = container.getSourceName() + File.separator + resource.getName();
            File targetFile = this.isOldHfsFormat ? new File(targetDir, containerWithResource) : new File(targetDir, resource.getName());
            if (!targetFile.isFile()) continue;
            this.deleteFile(targetFile);
        }
    }

    private void moveFile(File sourceFile, File targetFile) {
        Move move = new Move();
        move.setFile(sourceFile);
        move.setTofile(targetFile);
        move.setFailOnError(true);
        move.setVerbose(true);
        move.setOverwrite(true);
        move.execute();
    }

    private void deleteFile(File file) {
        Delete delete = new Delete();
        delete.setFile(file);
        delete.setFailOnError(true);
        delete.setVerbose(true);
        delete.execute();
    }

    private void deleteDirectory(File directory) {
        Delete delete = new Delete();
        delete.setDir(directory);
        delete.setFailOnError(true);
        delete.setVerbose(true);
        delete.execute();
    }
}

