/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.submit;

import com.ibm.urbancode.zos.common.util.StringHelper;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class JclFormatter {
    private static final int JCL_CODE_LENGTH = 71;
    private static final int JCL_LENGTH_WITH_LINE_NUMBERS = 80;
    private static final int JCL_LENGTH_WITHOUT_LINE_NUMBERS = 72;
    private static final String LINE_BREAK = "\n";
    private static final String JCL_COMMENT_PREFIX = "//*";
    private static final String SINGLE_SPACE = " ";
    private final String encoding;
    private final byte byteForSpace;
    private boolean isJclLineExceeds71CharsLimit = false;

    public JclFormatter(String encoding) {
        this.encoding = encoding;
        this.byteForSpace = this.getByteForSpace();
    }

    private byte getByteForSpace() {
        try {
            String whiteSpace = new String(SINGLE_SPACE.getBytes(), this.encoding);
            byte[] whitespaceBytes = whiteSpace.getBytes(this.encoding);
            return whitespaceBytes[0];
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFormattedJcl(String originalJcl, String jclWithReplacedTokens) throws UnsupportedEncodingException {
        List<String> originalJclLines = StringHelper.getLines(originalJcl);
        List<String> jclLinesWithReplacedTokens = StringHelper.getLines(jclWithReplacedTokens);
        ArrayList<String> formattedJclLines = new ArrayList<String>();
        for (int lineNo = 0; lineNo < jclLinesWithReplacedTokens.size(); ++lineNo) {
            String jclLineWithReplacedTokens = jclLinesWithReplacedTokens.get(lineNo);
            String originalJclLine = originalJclLines.get(lineNo);
            formattedJclLines.add(this.getFormattedJclLine(jclLineWithReplacedTokens, originalJclLine, lineNo));
        }
        if (this.isJclLineExceeds71CharsLimit) {
            throw new InvalidInputException("Job not submitted because the content exceed 71 bytes after replacing tokens.");
        }
        return String.join((CharSequence)LINE_BREAK, formattedJclLines);
    }

    private String getFormattedJclLine(String jclLineWithReplacedTokens, String originalJclLine, int lineNo) throws UnsupportedEncodingException {
        if (this.isJclCommentLine(jclLineWithReplacedTokens)) {
            return jclLineWithReplacedTokens;
        }
        if (this.isJclLineContainsPunchCardNumbersOrContinuationCharacter(originalJclLine)) {
            if (jclLineWithReplacedTokens.length() < originalJclLine.length()) {
                return this.getJclLineWithBlanksFilled(originalJclLine, jclLineWithReplacedTokens);
            }
            if (jclLineWithReplacedTokens.length() == originalJclLine.length()) {
                return jclLineWithReplacedTokens;
            }
            return this.getJclLineWithBlanksRemoved(originalJclLine, jclLineWithReplacedTokens, originalJclLine.length(), lineNo);
        }
        if (jclLineWithReplacedTokens.length() <= 71) {
            return jclLineWithReplacedTokens;
        }
        return this.getJclLineWithBlanksRemoved(originalJclLine, jclLineWithReplacedTokens, 71, lineNo);
    }

    private boolean isJclCommentLine(String jclLine) {
        return jclLine.startsWith(JCL_COMMENT_PREFIX);
    }

    private boolean isJclLineContainsPunchCardNumbersOrContinuationCharacter(String originalJclLine) throws UnsupportedEncodingException {
        return originalJclLine.length() == 80 || originalJclLine.length() == 72 && this.hasContinuationCharacter(originalJclLine);
    }

    private boolean hasContinuationCharacter(String jclLine) throws UnsupportedEncodingException {
        byte[] jclLineBytes = jclLine.getBytes(this.encoding);
        byte jclLine72CharacterByte = jclLineBytes[71];
        return jclLine72CharacterByte != this.byteForSpace;
    }

    private String getJclLineWithBlanksRemoved(String originalJclLine, String jclLineWithReplacedTokens, int availableJclLineLength, int lineNumber) throws UnsupportedEncodingException {
        byte[] jclRecordBytesAfterTokenReplace = jclLineWithReplacedTokens.getBytes(this.encoding);
        byte[] tempArray = new byte[availableJclLineLength];
        Arrays.fill(tempArray, this.byteForSpace);
        int metadataLength = availableJclLineLength - 71;
        int jclRecordLengthWithoutLineMetaInfoAndSpaces = jclLineWithReplacedTokens.length() - metadataLength;
        while (jclRecordBytesAfterTokenReplace[--jclRecordLengthWithoutLineMetaInfoAndSpaces] == this.byteForSpace) {
        }
        if (++jclRecordLengthWithoutLineMetaInfoAndSpaces > 71) {
            System.out.println("Error: line " + (lineNumber + 1) + " exceeds " + 71 + " bytes.");
            System.out.println(lineNumber + 1 + ":" + jclLineWithReplacedTokens);
            this.isJclLineExceeds71CharsLimit = true;
            return "";
        }
        System.arraycopy(jclRecordBytesAfterTokenReplace, 0, tempArray, 0, jclRecordLengthWithoutLineMetaInfoAndSpaces);
        if (metadataLength > 0) {
            System.arraycopy(originalJclLine.getBytes(this.encoding), 71, tempArray, 71, metadataLength);
        }
        return new String(tempArray, this.encoding);
    }

    private String getJclLineWithBlanksFilled(String originalJclLine, String jclLineWithReplacedTokens) throws UnsupportedEncodingException {
        byte[] tempArray = new byte[originalJclLine.length()];
        Arrays.fill(tempArray, this.byteForSpace);
        int metadataLength = originalJclLine.length() - 71;
        System.arraycopy(jclLineWithReplacedTokens.getBytes(this.encoding), 0, tempArray, 0, jclLineWithReplacedTokens.length() - metadataLength);
        System.arraycopy(originalJclLine.getBytes(this.encoding), 71, tempArray, 71, metadataLength);
        return new String(tempArray, this.encoding);
    }
}

