/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.urbancode.zos.common.util.AgentInstalledProperties;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.rexx.RexxExecutor;
import com.urbancode.air.plugin.command.version.common.TarUtil;
import com.urbancode.air.plugin.command.version.deployment.DatasetsPropertiesXml;
import com.urbancode.air.plugin.command.version.deployment.DeployManifestMvsGenerator;
import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class NewPackageFormatDeployer {
    private static final String SPACE = " ";
    private static final String DOUBLE_QUOTE = "\"";
    private final boolean isTraceOn;
    private final String tempDsnPrefix;
    private final String componentVersionWorkingDir;
    private final String manifestDeployFilePath;
    private final String deployManifestMvsPath;
    private final String datasetPropertiesFilePath;

    public NewPackageFormatDeployer(boolean isTraceOn, String tempDsnPrefix, String componentVersionWorkingDir) {
        this.isTraceOn = isTraceOn;
        this.tempDsnPrefix = tempDsnPrefix;
        this.componentVersionWorkingDir = componentVersionWorkingDir;
        this.manifestDeployFilePath = componentVersionWorkingDir + File.separator + "packageManifest_deploy.xml";
        this.deployManifestMvsPath = componentVersionWorkingDir + File.separator + "DeployManifestMvs.xml";
        this.datasetPropertiesFilePath = componentVersionWorkingDir + File.separator + "datasetProperties.xml";
    }

    public void deploy(String ispfGatewayBinPath) throws Exception {
        this.createDeployManifestMvsXmlFile();
        this.createDatasetPropertiesXmlFile();
        String packageZipFilePath = this.componentVersionWorkingDir + File.separator + "package.zip";
        if (FileHelper.isFileExist(packageZipFilePath)) {
            String zipFilePath = this.componentVersionWorkingDir + File.separator + "package.zip";
            TarUtil.untar(this.componentVersionWorkingDir, zipFilePath);
        }
        RexxExecutor rexxExecutor = new RexxExecutor(this.tempDsnPrefix, ispfGatewayBinPath);
        rexxExecutor.execute(PluginFilesHelper.getDeploymentV2RexxFilePath(), this.getRexxArguments());
    }

    private void createDeployManifestMvsXmlFile() throws XMLStreamException, IOException {
        String xmlString = DeployManifestMvsGenerator.generate(this.manifestDeployFilePath);
        FileHelper.writeStringToFile(xmlString, this.deployManifestMvsPath);
    }

    private void createDatasetPropertiesXmlFile() throws XMLStreamException, IOException {
        String datasetPropertiesXml = DatasetsPropertiesXml.generate(this.manifestDeployFilePath);
        FileHelper.writeStringToFile(datasetPropertiesXml, this.datasetPropertiesFilePath);
    }

    private String getRexxArguments() {
        AgentInstalledProperties agentInstalledProperties = AgentInstalledProperties.getInstance();
        String containerMapperFilePath = this.componentVersionWorkingDir + File.separator + "containerMapper.xml";
        return DOUBLE_QUOTE + this.deployManifestMvsPath + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + containerMapperFilePath + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + this.datasetPropertiesFilePath + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + this.isTraceOn + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + TempDsnNameHelper.getReceiveDataset(this.tempDsnPrefix) + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + this.componentVersionWorkingDir + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getTempUnit() + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getTempVolser() + DOUBLE_QUOTE;
    }
}

