/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ScriptExecutor {
    private static final String IBM_1047 = "IBM-1047";

    private ScriptExecutor() {
    }

    public static void execute(File scriptFile, String workDirPath) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(scriptFile.getAbsolutePath());
        processBuilder.directory(new File(workDirPath));
        Process process = processBuilder.start();
        ScriptExecutor.printProcessStream(process.getInputStream());
        ScriptExecutor.printProcessStream(process.getErrorStream());
        int exitCode = process.waitFor();
        if (exitCode > 0) {
            throw new RuntimeException("Copy from Datasets failed with exit code " + exitCode);
        }
    }

    private static void printProcessStream(InputStream inputStream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, IBM_1047));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

