/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.environment;

import com.urbancode.commons.util.Case;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.environment.Environment;
import com.urbancode.commons.util.immutable.IImmutableMap;
import com.urbancode.commons.util.immutable.ImmutableTreeMap;
import java.util.Map;
import java.util.TreeMap;

final class CaseInsensitiveEnvironment
extends Environment {
    CaseInsensitiveEnvironment(Map<String, String> environment) {
        super(environment);
    }

    @Override
    public Environment copy() {
        return new CaseInsensitiveEnvironment(this.get());
    }

    @Override
    public Case getCaseSensitivity() {
        return Case.INSENSITIVE;
    }

    @Override
    protected IImmutableMap<String, String> newImmutableMap(Map<String, String> value) {
        Check.nonNull(value, "value");
        IImmutableMap<String, String> result = ImmutableTreeMap.empty(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, String> e : value.entrySet()) {
            result = result.with(e.getKey(), e.getValue());
        }
        return result;
    }

    @Override
    protected Map<String, String> newMap(Map<String, String> value) {
        Check.nonNull(value, "value");
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        result.putAll(value);
        return result;
    }
}

