/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import com.ibm.urbancode.zos.zinventory.ZInventoryEntry;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ZInventoryDataMerger {
    public static JSONArray mergeData(JSONArray newData, JSONArray oldData) throws JSONException {
        Set<ZInventoryEntry> mergedEntries = ZInventoryDataMerger.getZInventoryEntries(newData, "DEPLOY");
        Set<ZInventoryEntry> deletedEntries = ZInventoryDataMerger.getZInventoryEntries(newData, "DELETE");
        Set<ZInventoryEntry> oldEntries = ZInventoryDataMerger.getOldZInventoryEntries(oldData, deletedEntries);
        mergedEntries.addAll(oldEntries);
        return ZInventoryDataMerger.convertSetToJSONArray(mergedEntries);
    }

    private static Set<ZInventoryEntry> getOldZInventoryEntries(JSONArray oldData, Set<ZInventoryEntry> deletedEntries) throws JSONException {
        LinkedHashSet<ZInventoryEntry> oldEntries = new LinkedHashSet<ZInventoryEntry>();
        for (int i = 0; i < oldData.length(); ++i) {
            JSONObject obj = oldData.getJSONObject(i);
            oldEntries.add(ZInventoryEntry.fromJSONObject(obj));
        }
        oldEntries.removeAll(deletedEntries);
        return oldEntries;
    }

    private static Set<ZInventoryEntry> getZInventoryEntries(JSONArray jsonArray, String filterOperationType) throws JSONException {
        LinkedHashSet<ZInventoryEntry> entries = new LinkedHashSet<ZInventoryEntry>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            String operationType = obj.getString("operation-type");
            if (!operationType.equalsIgnoreCase(filterOperationType)) continue;
            entries.add(ZInventoryEntry.fromJSONObject(obj));
        }
        return entries;
    }

    private static JSONArray convertSetToJSONArray(Set<ZInventoryEntry> mergedEntries) throws JSONException {
        JSONArray mergedArray = new JSONArray();
        for (ZInventoryEntry entry : mergedEntries) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)entry.getName());
            obj.put("inputs", (Object)entry.getInputs());
            obj.put("operation-type", (Object)entry.getOperationType());
            obj.put("deploy-type", (Object)entry.getDeployType());
            obj.put("target-type", (Object)entry.getTargetType());
            obj.put("target", (Object)entry.getTarget());
            obj.put("deploy-time", entry.getDeployTime());
            mergedArray.put((Object)obj);
        }
        return mergedArray;
    }
}

