/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.deployment.common.PackageManifestUtil;
import com.ibm.urbancode.groovy.xml.utils.DatasetContainerRemover;
import com.ibm.urbancode.groovy.xml.utils.InventoryDeltaCalculator;
import com.ibm.urbancode.groovy.xml.utils.NewRuntimeDeltaCalculator;
import com.ibm.urbancode.groovy.xml.utils.OldRuntimeDeltaCalculator;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.InstalledAgentVersion;
import com.ibm.urbancode.zos.common.util.StringHelper;
import com.ibm.urbancode.zos.common.util.UdClientHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.zinventory.TimeTracker;
import com.ibm.urbancode.zos.zinventory.ZInventoryTable;
import com.urbancode.air.plugin.command.version.common.CheckAccessExecutor;
import com.urbancode.air.plugin.command.version.common.PackageManifestHelper;
import com.urbancode.air.plugin.command.version.deployment.ContainerFilterMatcher;
import com.urbancode.air.plugin.command.version.deployment.DeployPackageHelper;
import com.urbancode.air.plugin.command.version.deployment.DeploymentHelper;
import com.urbancode.air.plugin.command.version.mappings.ContainerMapperHfsXml;
import com.urbancode.air.plugin.command.version.mappings.ContainerMapperMvsXml;
import com.urbancode.air.plugin.command.version.mappings.DatasetMapper;
import com.urbancode.air.plugin.command.version.mappings.DatasetMappingResolver;
import com.urbancode.air.plugin.command.version.mappings.HfsMapper;
import com.urbancode.air.plugin.command.version.mappings.HfsMappingResolver;
import com.urbancode.air.plugin.inputs.DeployPackageInputs;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.ResourceClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

public class DeployPackage {
    private static final String VERSION_7_1_1 = "7.1.1";
    private static final String IGNORE_QUALIFIERS = "ignoreQualifiers";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public DeployPackage(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws Exception {
        int exitCode;
        try {
            exitCode = this.deploy();
        }
        catch (Exception e) {
            Console.printActionTitle("Error deploying version." + e.getMessage());
            e.printStackTrace();
            exitCode = 1;
        }
        return exitCode;
    }

    private int deploy() throws Exception {
        DeployPackageInputs pluginInputs = DeployPackageInputs.getValidatedInputs(this.inputProperties);
        String componentVersionWorkingDir = DeploymentFilesHelper.getVersionDirPathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId());
        DeploymentHelper deploymentHelper = new DeploymentHelper(pluginInputs);
        String deployManifestFilePath = DeploymentFilesHelper.getFilePathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId(), "deployManifest.xml");
        String packageManifestFilePath = DeploymentFilesHelper.getFilePathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId(), "packageManifest.xml");
        String packageManifestBackupDeployFilePath = DeploymentFilesHelper.getFilePathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId(), "packageManifest_backup_deploy.xml");
        String deployContainerTrackerPath = DeploymentFilesHelper.getFilePathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId(), "deployContainerTracker.txt");
        String deployTimeTrackerPath = DeploymentFilesHelper.getFilePathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId(), "timeTracker.txt");
        String packageManifestDeployFilePath = DeploymentFilesHelper.getFilePathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId(), "packageManifest_deploy.xml");
        if (pluginInputs.isLinkedVersion() && FileHelper.isFileNotExist(deployContainerTrackerPath)) {
            if (FileHelper.isFileNotExist(deployManifestFilePath)) {
                throw new IllegalArgumentException(deployManifestFilePath + " not found. Please make sure Download Version for zOS plug-in step is successfully executed before the Deploy Data Set plug-in step.");
            }
            FileHelper.copyFile(deployManifestFilePath, packageManifestFilePath);
        }
        if (FileHelper.isFileNotExist(packageManifestFilePath)) {
            if (pluginInputs.hasContainerFilter()) {
                Console.printActionTitle("INFO: Nothing to deploy in partial deployment.");
                this.outputProperties.setProperty("remainingDatasets", "0");
                return 0;
            }
            throw new IllegalArgumentException(packageManifestFilePath + " not found. Please make sure Copy Artifacts, FTP Artifacts or Download Artifacts for zOS plug-in step is successfully executed before the Deploy Data Set plug-in step.");
        }
        PackageManifest packageManifestXml = PackageManifest.from((String)packageManifestFilePath);
        if (FileHelper.isFileNotExist(deployContainerTrackerPath)) {
            if (packageManifestXml.hasOnlyGenericArtifacts()) {
                Console.printActionTitle("No file artifacts to deploy. Version contains only generic artifacts.");
                deploymentHelper.postDeployForGenericOnly();
                FileHelper.cleanDirectory(componentVersionWorkingDir);
                return 0;
            }
            if (pluginInputs.incrementalModeIsInventory() && packageManifestXml.hasDataset()) {
                Console.printActionTitle("Calculate delta deployment using inventory status:");
                JSONArray intersectionData = this.getIntersectArtifactsInTargetResource(pluginInputs);
                if (intersectionData.length() == 0) {
                    System.out.println("No artifacts found in inventory. Skip delta deployment.");
                } else {
                    int ignoreQualifiers = this.getComponentHlqLength(pluginInputs.getComponentId());
                    new InventoryDeltaCalculator(intersectionData.toString(), packageManifestFilePath, ignoreQualifiers).calculate();
                }
            }
            FileHelper.copyFile(packageManifestFilePath, packageManifestDeployFilePath);
        }
        PackageManifest manifestDeployXml = PackageManifest.from((String)packageManifestDeployFilePath);
        if (FileHelper.isFileNotExist(deployContainerTrackerPath)) {
            if (manifestDeployXml.hasHFSFile()) {
                pluginInputs.validateHFSInputs();
                if (!pluginInputs.isOldHfsMappingFormat()) {
                    DeploymentFilesHelper.createTempFileForNewHFSMappingFormat(componentVersionWorkingDir);
                }
            }
            if (manifestDeployXml.hasDataset()) {
                if (pluginInputs.getPdsMapping().isEmpty()) {
                    Console.printProcessOutput(" [Error] Dataset Mapping is empty.");
                    return 1;
                }
                Set<String> datasetsInPackageManifest = PackageManifestHelper.getDatasets(manifestDeployXml);
                DatasetMapper mapper = DatasetMapper.from(pluginInputs.getPdsMapping());
                Map<String, Set<String>> srcTargetDatasetMap = DatasetMappingResolver.resolve(mapper, datasetsInPackageManifest);
                this.createContainerMapperXmlFile(srcTargetDatasetMap, componentVersionWorkingDir);
                Set<String> dummyMappedContainers = DeployPackageHelper.getDummyMappedDatasets(datasetsInPackageManifest, srcTargetDatasetMap);
                if (!dummyMappedContainers.isEmpty()) {
                    DeployPackageHelper.printSkippingMessage(dummyMappedContainers);
                    DatasetContainerRemover.remove((String)packageManifestDeployFilePath, dummyMappedContainers);
                }
                if (srcTargetDatasetMap.size() == dummyMappedContainers.size()) {
                    Console.printActionTitle("No MVS Datasets to deploy.");
                } else {
                    Set<String> targetDatasets = DeployPackageHelper.getTargetDatasets(srcTargetDatasetMap);
                    if (!pluginInputs.isCreateDatasetAllowed()) {
                        this.checkIfTargetDatasetsExist(targetDatasets);
                    }
                    if (pluginInputs.isCheckAccessEnabled()) {
                        this.checkAccessForTargetDatasets(pluginInputs, targetDatasets);
                    }
                    if (pluginInputs.incrementalModeIsRuntime()) {
                        Console.printActionTitle("Calculate delta deployment using Target Environment status:");
                        if (InstalledAgentVersion.isGreaterThanOrEqualTo(VERSION_7_1_1)) {
                            new NewRuntimeDeltaCalculator(componentVersionWorkingDir).calculate(packageManifestDeployFilePath, srcTargetDatasetMap);
                        } else {
                            new OldRuntimeDeltaCalculator().calculate(packageManifestDeployFilePath, srcTargetDatasetMap);
                        }
                    }
                }
                FileHelper.copyFile(packageManifestDeployFilePath, packageManifestFilePath);
            }
            if (manifestDeployXml.hasHFSFile()) {
                Set<String> hfsNeedToDeploy = PackageManifestUtil.getAllDeployHFSFiles(manifestDeployXml);
                HfsMapper hfsMapper = HfsMapper.from(pluginInputs.getHfsMapping());
                Map<String, String> srcTargetMap = HfsMappingResolver.resolve(hfsMapper, hfsNeedToDeploy);
                String containerMapperHFSXml = ContainerMapperHfsXml.from(srcTargetMap);
                Console.printActionTitle("The containerMapperHFS.xml contents:");
                Console.printProcessOutput(containerMapperHFSXml);
                String containerMapperHFSXmlFilePath = componentVersionWorkingDir + File.separator + "containerMapperHFS.xml";
                FileHelper.writeStringToFile(containerMapperHFSXml, containerMapperHFSXmlFilePath);
                if (!pluginInputs.isCreateDirectoryAllowed()) {
                    this.checkIfTargetDirectoriesExist(new HashSet<String>(srcTargetMap.values()));
                }
            }
        }
        boolean isFirstTimePartialDeploy = true;
        File backupManifestFile = new File(packageManifestBackupDeployFilePath);
        if (backupManifestFile.exists() && pluginInputs.getContainerFilter().isEmpty()) {
            Console.printActionTitle("ERROR: Deployment Container filter is empty for partial deployment");
            return 1;
        }
        TimeTracker timeTracker = new TimeTracker(deployTimeTrackerPath);
        if (pluginInputs.hasContainerFilter()) {
            if (!backupManifestFile.exists() || !backupManifestFile.isFile()) {
                FileHelper.copyFile(packageManifestDeployFilePath, packageManifestBackupDeployFilePath);
                if (!new File(deployTimeTrackerPath).isFile()) {
                    timeTracker.setDeployTimeInTimeTrackerFile();
                }
            } else {
                FileHelper.copyFile(packageManifestBackupDeployFilePath, packageManifestDeployFilePath);
                isFirstTimePartialDeploy = false;
            }
        }
        if (!manifestDeployXml.hasHFSFile() && !manifestDeployXml.hasDataset()) {
            Console.printActionTitle("There is nothing to deploy.");
            if (pluginInputs.incrementalModeIsInventory()) {
                deploymentHelper.postDeploy(false);
                return 0;
            }
        }
        Set<String> containerDatasets = new HashSet<String>();
        if (manifestDeployXml.hasDataset() && pluginInputs.hasContainerFilter()) {
            HashSet<String> processedDataSets = new HashSet<String>();
            if (FileHelper.isFileExist(deployContainerTrackerPath)) {
                processedDataSets.addAll(FileHelper.getLines(deployContainerTrackerPath));
            }
            PackageManifest packageManifestDeploy = PackageManifest.from((String)packageManifestDeployFilePath);
            containerDatasets = PackageManifestHelper.getDatasets(packageManifestDeploy);
            int initialListSize = containerDatasets.size();
            List<String> containerFilters = StringHelper.getLines(pluginInputs.getContainerFilter());
            List<String> filteredDatasets = ContainerFilterMatcher.getFilteredDatasets(containerFilters, containerDatasets);
            filteredDatasets.forEach(containerDatasets::remove);
            this.appendDatasetsToFile(deployContainerTrackerPath, filteredDatasets);
            if (initialListSize == containerDatasets.size()) {
                Console.printActionTitle("\nWARNING: No containers present for deployment - ");
                Console.printProcessOutput("Either regular expression provided in Container Filter does not qualify any containers (or)");
                Console.printProcessOutput("Qualified containers are skipped due to delta deploy.");
                System.out.println();
                int remainingDS = deploymentHelper.printPartialDeployedDatasets();
                this.outputProperties.setProperty("remainingDatasets", String.valueOf(remainingDS));
                if (isFirstTimePartialDeploy && backupManifestFile.isFile()) {
                    backupManifestFile.delete();
                }
                return 0;
            }
            if (!processedDataSets.isEmpty()) {
                System.out.println();
                for (String dsName : processedDataSets) {
                    if (containerDatasets.contains(dsName)) continue;
                    Console.printProcessOutput("WARNING: Skipping deployment for container " + dsName + " as it is already deployed in previous steps.");
                    containerDatasets.add(dsName);
                }
                System.out.println();
            }
        }
        deploymentHelper.performDeployment(containerDatasets, isFirstTimePartialDeploy);
        ZInventoryTable.updateDeploymentData(pluginInputs, timeTracker, componentVersionWorkingDir);
        if (pluginInputs.hasContainerFilter()) {
            int remainingDS = deploymentHelper.printPartialDeployedDatasets();
            if (remainingDS > 0) {
                Console.printActionTitle("\nINFO: Skipping working directory clean up.");
            } else {
                FileHelper.cleanDirectory(componentVersionWorkingDir);
                Console.printActionTitle("\nINFO: No Datasets remaining for deployment, Cleaning up working directory.");
            }
            this.outputProperties.setProperty("remainingDatasets", String.valueOf(remainingDS));
        } else {
            FileHelper.cleanDirectory(componentVersionWorkingDir);
        }
        return 0;
    }

    private void appendDatasetsToFile(String deployContainerTrackerPath, List<String> filteredDatasets) throws IOException {
        Path trackerFilePath = Paths.get(deployContainerTrackerPath, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(trackerFilePath, Charset.defaultCharset(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            for (String dataset : filteredDatasets) {
                writer.write(dataset + "\n");
            }
        }
    }

    private void createContainerMapperXmlFile(Map<String, Set<String>> srcTargetDatasetMap, String workDir) throws XMLStreamException, IOException {
        String containerMapperMvsXml = ContainerMapperMvsXml.from(srcTargetDatasetMap);
        Console.printActionTitle("The containerMapper.xml contents:");
        Console.printProcessOutput(containerMapperMvsXml);
        String containerMapperXmlFilePath = workDir + File.separator + "containerMapper.xml";
        FileHelper.writeStringToFile(containerMapperMvsXml, containerMapperXmlFilePath);
    }

    private void checkIfTargetDatasetsExist(Set<String> targetDatasets) throws ZFileException {
        Console.printActionTitle("Check data sets exist:");
        List<String> missingDatasets = DatasetHelper.getMissingDatasets(targetDatasets);
        if (missingDatasets.isEmpty()) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder("Deploy failed because below target datasets are not found and Allow Creating Data Set is set to false.");
        for (String dataset : missingDatasets) {
            errorMessage.append(System.lineSeparator()).append(dataset);
        }
        throw new IllegalArgumentException(errorMessage.toString());
    }

    private void checkIfTargetDirectoriesExist(Set<String> targetDirs) {
        Console.printActionTitle("Check directories exist:");
        List<String> missingDirectories = FileHelper.getMissingDirectories(targetDirs);
        if (missingDirectories.isEmpty()) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder("Deploy failed because below target directories are not found and Allow Creating Directory is set to false.");
        for (String dir : missingDirectories) {
            errorMessage.append(System.lineSeparator()).append(dir);
        }
        throw new IllegalArgumentException(errorMessage.toString());
    }

    private void checkAccessForTargetDatasets(DeployPackageInputs pluginInputs, Set<String> targetDatasets) throws IOException, InterruptedException {
        String versionDirPath = DeploymentFilesHelper.getVersionDirPathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId());
        if (pluginInputs.isBackupEnabled()) {
            CheckAccessExecutor.executeForBackup(targetDatasets, versionDirPath);
        }
        CheckAccessExecutor.executeForDeploy(targetDatasets, versionDirPath);
    }

    private JSONArray getIntersectArtifactsInTargetResource(DeployPackageInputs pluginInputs) throws URISyntaxException, JSONException, IOException {
        ResourceClient resourceClient = UdClientHelper.getResourceClient();
        XTrustProvider.install();
        return resourceClient.intersectArtifactsInTargetResource(pluginInputs.getResourceId(), pluginInputs.getComponentId(), pluginInputs.getVersionId());
    }

    private int getComponentHlqLength(String componentId) throws URISyntaxException, JSONException, IOException {
        ComponentClient componentClient = UdClientHelper.getComponentClient();
        return (Integer)componentClient.getComponent(componentId).get(IGNORE_QUALIFIERS);
    }
}

