/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.team.enterprise.automation.CpDataset;
import com.ibm.team.enterprise.automation.dataset.DatasetInfo;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.common.XmlIndentHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class BackupDatasetPropertiesXml {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private static final String DATASETS_TAG = "datasets";
    private static final String DATASET_TAG = "dataset";
    private static final String DATASET_NAME_ATTRIBUTE = "name";
    private static final String LIB_TYPE = "LIB_TYPE";
    private static final String REC_ORG = "REC_ORG";
    private static final String REC_LEN = "REC_LEN";
    private static final String BLOCK_SIZE = "BLOCK_SIZE";
    private static final String REC_FORMAT = "REC_FORMAT";
    private static final String CP_OPTION = "CP_OPTION";
    private static final String PDSE = "PDSE";
    private static final String PDS = "PDS";
    private static final String SEQUENTIAL = "sequential";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private final List<CpDataset> cpDatasets;
    private XMLStreamWriter xmlStreamWriter = null;

    private BackupDatasetPropertiesXml(List<CpDataset> cpDatasets) {
        this.cpDatasets = cpDatasets;
    }

    public static String generate(List<CpDataset> cpDatasets) throws XMLStreamException, IOException {
        BackupDatasetPropertiesXml backupDatasetPropertiesXml = new BackupDatasetPropertiesXml(cpDatasets);
        return backupDatasetPropertiesXml.generateXML();
    }

    private String generateXML() throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements();
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements() throws XMLStreamException {
        this.createXmlHeaderTag();
        this.createStartingDatasetsTag();
        this.writeDatasets();
        this.writeEndingDatasetsTag();
        this.xmlStreamWriter.writeEndDocument();
    }

    private void createStartingDatasetsTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(DATASETS_TAG);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void createXmlHeaderTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeDatasets() throws XMLStreamException {
        for (CpDataset cpDataset : this.cpDatasets) {
            this.writeStartingDatasetTag(cpDataset.getName());
            this.writeProperty(CP_OPTION, cpDataset.getCpOption());
            DatasetInfo datasetInfo = DatasetInfo.from((String)cpDataset.getName());
            if (cpDataset.isSequentialDataset()) {
                this.writeProperty(LIB_TYPE, SEQUENTIAL);
            } else if (datasetInfo.isPDSE()) {
                this.writeProperty(LIB_TYPE, PDSE);
            } else {
                this.writeProperty(LIB_TYPE, PDS);
            }
            this.writeDatasetProperties(datasetInfo);
            this.writeEndElement();
        }
    }

    private void writeEndingDatasetsTag() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartingDatasetTag(String datasetName) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement(DATASET_TAG);
        this.xmlStreamWriter.writeAttribute(DATASET_NAME_ATTRIBUTE, datasetName);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeDatasetProperties(DatasetInfo datasetInfo) throws XMLStreamException {
        this.writeProperty(REC_ORG, datasetInfo.getDsOrg());
        this.writeProperty(REC_LEN, String.valueOf(datasetInfo.getRecordLength()));
        this.writeProperty(BLOCK_SIZE, String.valueOf(datasetInfo.getBlockSize()));
        this.writeProperty(REC_FORMAT, datasetInfo.getRecFM());
    }

    private void writeProperty(String propertyName, String propertyValue) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
        this.xmlStreamWriter.writeEmptyElement("property");
        this.xmlStreamWriter.writeAttribute(DATASET_NAME_ATTRIBUTE, propertyName);
        this.xmlStreamWriter.writeAttribute("value", propertyValue);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }
}

