/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import java.lang.reflect.Array;
import java.util.Random;

public final class ArrayUtil {
    private static final boolean[] BOOLEAN_EMPTY = new boolean[0];
    private static final byte[] BYTE_EMPTY = new byte[0];
    private static final char[] CHAR_EMPTY = new char[0];
    private static final short[] SHORT_EMPTY = new short[0];
    private static final int[] INT_EMPTY = new int[0];
    private static final long[] LONG_EMPTY = new long[0];
    private static final float[] FLOAT_EMPTY = new float[0];
    private static final double[] DOUBLE_EMPTY = new double[0];

    public static int append(boolean[] dest, int len, boolean[] src, int start, int end) {
        return ArrayUtil.append((Object)dest, len, (Object)src, start, end);
    }

    public static int append(byte[] dest, int len, byte[] src, int start, int end) {
        return ArrayUtil.append((Object)dest, len, (Object)src, start, end);
    }

    public static int append(char[] dest, int len, char[] src, int start, int end) {
        return ArrayUtil.append((Object)dest, len, (Object)src, start, end);
    }

    public static int append(double[] dest, int len, double[] src, int start, int end) {
        return ArrayUtil.append((Object)dest, len, (Object)src, start, end);
    }

    public static int append(float[] dest, int len, float[] src, int start, int end) {
        return ArrayUtil.append((Object)dest, len, (Object)src, start, end);
    }

    public static int append(int[] dest, int len, int[] src, int start, int end) {
        return ArrayUtil.append((Object)dest, len, (Object)src, start, end);
    }

    public static int append(long[] dest, int len, long[] src, int start, int end) {
        return ArrayUtil.append((Object)dest, len, (Object)src, start, end);
    }

    public static int append(short[] dest, int len, short[] src, int start, int end) {
        return ArrayUtil.append((Object)dest, len, (Object)src, start, end);
    }

    public static <T, S extends T> int append(T[] dest, int len, S[] src, int start, int end) {
        return ArrayUtil.append(dest, len, src, start, end);
    }

    public static void assertIsValidRange(int arrayLength, int offset, int length) {
        if (arrayLength < 0) {
            throw new IllegalArgumentException("arrayLength");
        }
        assert (offset >= 0) : String.format("offset %d < 0", offset);
        assert (length >= 0) : String.format("offset %d < 0", offset);
        assert (offset <= arrayLength) : String.format("offset %d > array.length %d", offset, arrayLength);
        assert (!ArrayUtil.isOffsetPlusLengthTooLarge(arrayLength, offset, length)) : String.format("offset %d + length %d > array.length %d", offset, length, arrayLength);
    }

    public static void checkIsValidRange(int arrayLength, int offset, int length) {
        if (arrayLength < 0) {
            throw new IllegalArgumentException("arrayLength");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(String.format("offset %d < 0", offset));
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException(String.format("offset %d < 0", offset));
        }
        if (offset > arrayLength) {
            throw new IndexOutOfBoundsException(String.format("offset %d > array.length %d", offset, arrayLength));
        }
        if (ArrayUtil.isOffsetPlusLengthTooLarge(arrayLength, offset, length)) {
            throw new IndexOutOfBoundsException(String.format("offset %d + length %d > array.length %d", offset, length, arrayLength));
        }
    }

    public static boolean contains(boolean[] array, boolean target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static boolean contains(byte[] array, byte target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static boolean contains(char[] array, char target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static boolean contains(double[] array, double target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static boolean contains(float[] array, float target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static boolean contains(int[] array, int target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static boolean contains(long[] array, long target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static boolean contains(short[] array, short target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static <T> boolean contains(T[] array, T target, int start, int end) {
        return ArrayUtil.indexOf(array, target, start, end) != -1;
    }

    public static boolean[] copy(boolean[] array) {
        return array == null ? null : (boolean[])array.clone();
    }

    public static byte[] copy(byte[] array) {
        return array == null ? null : (byte[])array.clone();
    }

    public static char[] copy(char[] array) {
        return array == null ? null : (char[])array.clone();
    }

    public static double[] copy(double[] array) {
        return array == null ? null : (double[])array.clone();
    }

    public static float[] copy(float[] array) {
        return array == null ? null : (float[])array.clone();
    }

    public static int[] copy(int[] array) {
        return array == null ? null : (int[])array.clone();
    }

    public static long[] copy(long[] array) {
        return array == null ? null : (long[])array.clone();
    }

    public static short[] copy(short[] array) {
        return array == null ? null : (short[])array.clone();
    }

    public static <T> T[] copy(T[] array) {
        return array == null ? null : (Object[])array.clone();
    }

    public static boolean[] copyNonNull(boolean[] array) {
        return array == null ? BOOLEAN_EMPTY : (boolean[])array.clone();
    }

    public static byte[] copyNonNull(byte[] array) {
        return array == null ? BYTE_EMPTY : (byte[])array.clone();
    }

    public static char[] copyNonNull(char[] array) {
        return array == null ? CHAR_EMPTY : (char[])array.clone();
    }

    public static double[] copyNonNull(double[] array) {
        return array == null ? DOUBLE_EMPTY : (double[])array.clone();
    }

    public static float[] copyNonNull(float[] array) {
        return array == null ? FLOAT_EMPTY : (float[])array.clone();
    }

    public static int[] copyNonNull(int[] array) {
        return array == null ? INT_EMPTY : (int[])array.clone();
    }

    public static long[] copyNonNull(long[] array) {
        return array == null ? LONG_EMPTY : (long[])array.clone();
    }

    public static short[] copyNonNull(short[] array) {
        return array == null ? SHORT_EMPTY : (short[])array.clone();
    }

    public static <T> T[] copyNonNull(T[] array, Class<T> componentType) {
        return array == null ? ArrayUtil.emptyArray(componentType) : (Object[])array.clone();
    }

    public static boolean[] ensure(boolean[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            boolean[] tmp = new boolean[ArrayUtil.cap(array.length, minCap)];
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static byte[] ensure(byte[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            byte[] tmp = new byte[ArrayUtil.cap(array.length, minCap)];
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static char[] ensure(char[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            char[] tmp = new char[ArrayUtil.cap(array.length, minCap)];
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static double[] ensure(double[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            double[] tmp = new double[ArrayUtil.cap(array.length, minCap)];
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static float[] ensure(float[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            float[] tmp = new float[ArrayUtil.cap(array.length, minCap)];
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static int[] ensure(int[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            int[] tmp = new int[ArrayUtil.cap(array.length, minCap)];
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static long[] ensure(long[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            long[] tmp = new long[ArrayUtil.cap(array.length, minCap)];
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static short[] ensure(short[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            short[] tmp = new short[ArrayUtil.cap(array.length, minCap)];
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static <T> T[] ensure(T[] array, int len, int increase) {
        int minCap = len + increase;
        if (minCap > array.length) {
            Object[] tmp = (Object[])Array.newInstance(array.getClass().getComponentType(), ArrayUtil.cap(array.length, minCap));
            System.arraycopy(array, 0, tmp, 0, len);
            array = tmp;
        }
        return array;
    }

    public static int indexOf(boolean[] array, boolean target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int indexOf(byte[] array, byte target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int indexOf(char[] array, char target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int indexOf(double[] array, double target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int indexOf(float[] array, float target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int indexOf(int[] array, int target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int indexOf(long[] array, long target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int indexOf(short[] array, short target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            result = i;
            break;
        }
        return result;
    }

    public static <T> int indexOf(T[] array, T target, int start, int end) {
        int result = -1;
        for (int i = start; i < end; ++i) {
            if (!ArrayUtil.equals(array[i], target)) continue;
            result = i;
            break;
        }
        return result;
    }

    public static boolean isValidRange(int arrayLength, int offset, int length) {
        if (arrayLength < 0) {
            throw new IllegalArgumentException("arrayLength");
        }
        boolean result = true;
        if (offset < 0 || length < 0 || offset > arrayLength || ArrayUtil.isOffsetPlusLengthTooLarge(arrayLength, offset, length)) {
            result = false;
        }
        return result;
    }

    public static boolean[] resize(boolean[] array, int len) {
        boolean[] result = array;
        if (array.length != len) {
            boolean[] tmp = new boolean[len];
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static byte[] resize(byte[] array, int len) {
        byte[] result = array;
        if (array.length != len) {
            byte[] tmp = new byte[len];
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static char[] resize(char[] array, int len) {
        char[] result = array;
        if (array.length != len) {
            char[] tmp = new char[len];
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static double[] resize(double[] array, int len) {
        double[] result = array;
        if (array.length != len) {
            double[] tmp = new double[len];
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static float[] resize(float[] array, int len) {
        float[] result = array;
        if (array.length != len) {
            float[] tmp = new float[len];
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static int[] resize(int[] array, int len) {
        int[] result = array;
        if (array.length != len) {
            int[] tmp = new int[len];
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static long[] resize(long[] array, int len) {
        long[] result = array;
        if (array.length != len) {
            long[] tmp = new long[len];
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static short[] resize(short[] array, int len) {
        short[] result = array;
        if (array.length != len) {
            short[] tmp = new short[len];
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static <T> T[] resize(T[] array, int len) {
        Object[] result = array;
        if (array.length != len) {
            Object[] tmp = (Object[])Array.newInstance(array.getClass().getComponentType(), len);
            System.arraycopy(array, 0, tmp, 0, len);
            result = tmp;
        }
        return result;
    }

    public static void reverse(boolean[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            boolean t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void reverse(byte[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            byte t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void reverse(char[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            char t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void reverse(double[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            double t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void reverse(float[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            float t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void reverse(int[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            int t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void reverse(long[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            long t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void reverse(short[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            short t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static <T> void reverse(T[] array, int start, int end) {
        int i = start;
        for (int j = end - 1; i < j; ++i, --j) {
            T t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void shuffle(Random rnd, boolean[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            boolean t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void shuffle(Random rnd, byte[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            byte t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void shuffle(Random rnd, char[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            char t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void shuffle(Random rnd, double[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            double t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void shuffle(Random rnd, float[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            float t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void shuffle(Random rnd, int[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            int t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void shuffle(Random rnd, long[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            long t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void shuffle(Random rnd, short[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            short t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static <T> void shuffle(Random rnd, T[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1) + start;
            T t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static int unique(boolean[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (array[dest] == array[i]) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static int unique(byte[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (array[dest] == array[i]) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static int unique(char[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (array[dest] == array[i]) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static int unique(double[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (array[dest] == array[i]) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static int unique(float[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (array[dest] == array[i]) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static int unique(int[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (array[dest] == array[i]) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static int unique(long[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (array[dest] == array[i]) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static int unique(short[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (array[dest] == array[i]) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static <T> int unique(T[] array, int start, int end) {
        int result = end;
        if (start != end) {
            int dest = start;
            for (int i = start + 1; i < end; ++i) {
                if (ArrayUtil.equals(array[dest], array[i])) continue;
                array[++dest] = array[i];
            }
            result = dest + 1;
        }
        return result;
    }

    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        try {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = ArrayUtil.formatArraycopyError(src, srcPos, dest, destPos, length, e);
            throw (ArrayIndexOutOfBoundsException)new ArrayIndexOutOfBoundsException(msg).initCause(e);
        }
        catch (ArrayStoreException e) {
            String msg = ArrayUtil.formatArraycopyError(src, srcPos, dest, destPos, length, e);
            throw (ArrayStoreException)new ArrayStoreException(msg).initCause(e);
        }
        catch (NullPointerException e) {
            String msg = ArrayUtil.formatArraycopyError(src, srcPos, dest, destPos, length, e);
            throw (NullPointerException)new NullPointerException(msg).initCause(e);
        }
    }

    private static String formatArraycopyError(Object src, int srcPos, Object dest, int destPos, int length, Throwable t) {
        String msg = t.getMessage();
        msg = msg != null ? ": " + msg : "";
        msg = String.format("src=%s, srcPos=%d, dest=%s, destPos=%d, length=%d%s", ArrayUtil.describeArray(src), srcPos, ArrayUtil.describeArray(dest), destPos, length, msg);
        return msg;
    }

    private static String describeArray(Object src) {
        if (src == null) {
            return "null";
        }
        String name = src.getClass().getSimpleName();
        if (!src.getClass().isArray()) {
            if (name.length() == 0) {
                name = "<anon>";
            }
            return name + "@" + Integer.toHexString(System.identityHashCode(src));
        }
        int depth = 0;
        while (name.endsWith("[]")) {
            ++depth;
            name = name.substring(0, name.length() - 2);
        }
        if (name.length() == 0) {
            name = "<anon>";
        }
        name = name + "[" + Array.getLength(src) + "]";
        while (depth > 1) {
            --depth;
            name = name + "[]";
        }
        return name + "@" + Integer.toHexString(System.identityHashCode(src));
    }

    private static int append(Object dest, int len, Object src, int start, int end) {
        int srclen = end - start;
        int result = len + srclen;
        System.arraycopy(src, start, dest, len, srclen);
        return result;
    }

    private static int cap(int arrayLen, int minCap) {
        return Math.max(2 * arrayLen, minCap);
    }

    private static <T> T[] emptyArray(Class<T> componentType) {
        return (Object[])Array.newInstance(componentType, 0);
    }

    private static boolean equals(Object a, Object b) {
        boolean result = a != null ? a.equals(b) : b == null;
        return result;
    }

    private static boolean isOffsetPlusLengthTooLarge(int arrayLength, int offset, int length) {
        return length > arrayLength - offset;
    }

    private ArrayUtil() {
        throw new UnsupportedOperationException();
    }
}

