/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import java.text.DecimalFormat;
import java.util.Date;

public class Duration {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    private static final DecimalFormat msFormat = new DecimalFormat("000");
    private final Date start;
    private final Date end;
    private final long duration;

    public static String getString(Date start, Date end) {
        return new Duration(start, end).toString();
    }

    public Duration(Date start, Date end) {
        if (start == null) {
            throw new IllegalArgumentException("Start date is null");
        }
        this.start = (Date)start.clone();
        this.end = end == null ? new Date() : (Date)end.clone();
        this.duration = this.end.getTime() - this.start.getTime();
    }

    public Duration(long duration) {
        this.duration = Math.abs(duration);
        this.start = null;
        this.end = null;
    }

    public Duration(int duration) {
        this((long)duration);
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.clone();
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.clone();
    }

    @Deprecated
    public long getMilis() {
        return this.getMillis();
    }

    public long getMillis() {
        return this.duration;
    }

    public String toString() {
        String result = null;
        result = this.getHours() + ":";
        result = result + this.getMinutes() + ":";
        result = result + this.getSeconds();
        return result;
    }

    public String getLeastUnit() {
        return this.getLeastUnit(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLeastUnit(boolean abbreviated, boolean showMillis) {
        long tmpDuration = this.duration;
        StringBuilder sb = new StringBuilder();
        if (tmpDuration > 86400000L) {
            sb.append(tmpDuration / 86400000L);
            if (abbreviated) {
                sb.append(" d ");
            } else {
                sb.append(" days ");
            }
            tmpDuration %= 86400000L;
        }
        if (tmpDuration > 3600000L) {
            sb.append(tmpDuration / 3600000L);
            if (abbreviated) {
                sb.append(" h ");
            } else {
                sb.append(" hours ");
            }
            tmpDuration %= 3600000L;
        }
        if (tmpDuration > 60000L) {
            sb.append(tmpDuration / 60000L);
            if (abbreviated) {
                sb.append(" m ");
            } else {
                sb.append(" minutes ");
            }
            tmpDuration %= 60000L;
        }
        sb.append(tmpDuration / 1000L);
        tmpDuration %= 1000L;
        if (showMillis) {
            sb.append(".");
            DecimalFormat decimalFormat = msFormat;
            synchronized (decimalFormat) {
                sb.append(msFormat.format(tmpDuration));
            }
        }
        if (abbreviated) {
            sb.append(" s ");
        } else {
            sb.append(" seconds ");
        }
        return sb.toString();
    }

    private String getHours() {
        String result = null;
        result = String.valueOf(this.duration / 3600000L);
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    private String getMinutes() {
        String result = null;
        result = String.valueOf(this.duration % 3600000L / 60000L);
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    private String getSeconds() {
        String result = null;
        result = String.valueOf(this.duration % 60000L / 1000L);
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }
}

