/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ResultSetProxyGenerator {
    private static final Set<String> MOVING_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("next", "previous", "first", "last", "aboslute", "relative", "afterLast", "beforeFirst", "moveToCurrentRow", "moveToInsertRow")));

    public static ResultSet nonMoving(final ResultSet rs) {
        ClassLoader classLoader = ResultSetProxyGenerator.class.getClassLoader();
        return (ResultSet)Proxy.newProxyInstance(classLoader, new Class[]{ResultSet.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (MOVING_METHODS.contains(methodName)) {
                    throw new UnsupportedOperationException("ResultSet position is not movable - " + methodName);
                }
                return method.invoke((Object)rs, args);
            }
        });
    }

    public static ResultSet ignoreNext(final ResultSet rs) {
        ClassLoader classLoader = ResultSetProxyGenerator.class.getClassLoader();
        return (ResultSet)Proxy.newProxyInstance(classLoader, new Class[]{ResultSet.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals("next")) {
                    return true;
                }
                return method.invoke((Object)rs, args);
            }
        });
    }

    private ResultSetProxyGenerator() {
    }
}

