/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.util.unix.ModeParseException;
import com.urbancode.commons.util.unix.UnixPermissions;
import com.urbancode.vfs.common.ClientObject;
import com.urbancode.vfs.common.ClientPathEntryBuilder;
import com.urbancode.vfs.common.Hash;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ClientPathEntry
implements ClientObject,
Comparable<ClientPathEntry> {
    private static final Pattern unixPermsPattern = Pattern.compile("([^:]*):([^:]*):([^:]*)");
    private String path;
    private Hash contentHash;
    private FileType type;
    private long length;
    private Long lastModified;
    private String linkPath;
    private Map<Class<?>, Object> permissionMap;
    private List<Hash> additionalHashes = new ArrayList<Hash>();
    private int version;
    private Charset charset;

    public static ClientPathEntry createDirectory(String path, Long lastModified, Set<?> permissionViews) {
        return new ClientPathEntryBuilder().path(path).type(FileType.DIRECTORY).length(0L).lastModified(lastModified).permissionsViews(permissionViews).version(1).build();
    }

    public static ClientPathEntry createFile(String path, Hash hash, long length, Long lastModified, Set<?> permissionViews) {
        return new ClientPathEntryBuilder().path(path).hash(hash).type(FileType.REGULAR).length(length).lastModified(lastModified).permissionsViews(permissionViews).build();
    }

    public static ClientPathEntry createFile(String path, Charset characterEncoding, Hash hash, long length, Long lastModified, Set<?> permissionViews) {
        return new ClientPathEntryBuilder().path(path).charset(characterEncoding).hash(hash).length(length).lastModified(lastModified).permissionsViews(permissionViews).build();
    }

    public static ClientPathEntry createFile(String path, Charset characterEncoding, Hash hash, long length, Long lastModified, Set<?> permissionViews, List<Hash> additionalHashes) {
        return new ClientPathEntryBuilder().path(path).type(FileType.REGULAR).charset(characterEncoding).hash(hash).length(length).lastModified(lastModified).permissionsViews(permissionViews).additionalHashes(additionalHashes).version(1).build();
    }

    public static ClientPathEntry createSymlink(String path, String linkPath, Long lastModified, Set<?> permissionViews) {
        return new ClientPathEntryBuilder().path(linkPath).type(FileType.SYMLINK).length(0L).lastModified(lastModified).linkPath(linkPath).permissionsViews(permissionViews).version(1).build();
    }

    public static ClientPathEntry[] createPathEntriesFromFileSystem(File baseFile, String[] includes, String[] excludes, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, FileListerBuilder.Symlinks symlinks, String hashAlgorithm) throws IOException, NoSuchAlgorithmException {
        return new ClientPathEntryBuilder().baseFile(baseFile).includes(includes).excludes(excludes).directories(directories).permissions(permissions).symlinks(symlinks).hashAlgorithms(hashAlgorithm).buildEntries();
    }

    public static ClientPathEntry[] createPathEntriesFromFileSystemWithPrefix(File baseFile, String[] includes, String[] excludes, String pathPrefix, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, FileListerBuilder.Symlinks symlinks, String ... hashAlgorithms) throws IOException, NoSuchAlgorithmException {
        return new ClientPathEntryBuilder().baseFile(baseFile).includes(includes).excludes(excludes).pathPrefix(pathPrefix).directories(directories).permissions(permissions).symlinks(symlinks).hashAlgorithms(hashAlgorithms).buildEntries();
    }

    public static ClientPathEntry fromJSON(JSONObject json) throws JSONException {
        ClientPathEntry entry = null;
        try {
            String path = json.getString("path");
            Hash contentHash = null;
            if (json.has("contentHash")) {
                contentHash = Hash.hashForString(json.getString("contentHash"));
            }
            int version = json.getInt("version");
            FileType type = FileType.valueOf((String)json.getString("type"));
            long length = json.getLong("length");
            Charset charset = null;
            if (json.has("charset")) {
                charset = Charset.forName(json.getString("charset"));
            }
            Long lastModified = null;
            if (json.has("modified")) {
                lastModified = json.getLong("modified");
            }
            String linkPath = null;
            if (FileType.SYMLINK.equals((Object)type)) {
                linkPath = json.getString("linkPath");
            }
            HashSet<UnixPermissions> permissionViews = null;
            if (json.has("unixPermissions")) {
                permissionViews = new HashSet<UnixPermissions>();
                Matcher matcher = unixPermsPattern.matcher(json.getString("unixPermissions"));
                if (matcher.matches()) {
                    String mode = matcher.group(1);
                    String user = matcher.group(2);
                    String group = matcher.group(3);
                    permissionViews.add(UnixPermissions.createFromOctal(mode, user, group));
                }
            }
            ArrayList<Hash> additionalHashes = null;
            if (json.has("additionalHashes")) {
                additionalHashes = new ArrayList<Hash>();
                JSONArray jsonHashes = json.getJSONArray("additionalHashes");
                for (int i = 0; i < jsonHashes.length(); ++i) {
                    additionalHashes.add(Hash.hashForString(jsonHashes.getString(i)));
                }
            }
            entry = new ClientPathEntryBuilder().path(path).type(type).charset(charset).hash(contentHash).length(length).lastModified(lastModified).linkPath(linkPath).permissionsViews(permissionViews).additionalHashes(additionalHashes).version(version).build();
        }
        catch (ModeParseException e) {
            throw new JSONException("Unable to parse permissions from JSON: " + e.getMessage());
        }
        return entry;
    }

    protected ClientPathEntry(String path, FileType type, Hash contentHash, long length, Long lastModified, String linkPath, Set<?> permissionViews, List<Hash> additionalHashes, int version) {
        this.path = path;
        this.contentHash = contentHash;
        this.type = type;
        this.length = length;
        this.lastModified = lastModified;
        this.linkPath = linkPath;
        this.version = version;
        if (additionalHashes != null) {
            this.additionalHashes.addAll(additionalHashes);
        }
        HashMap map = new HashMap();
        if (permissionViews != null) {
            for (Object permissionView : permissionViews) {
                Class<?> permissionViewClass = permissionView.getClass();
                if (map.containsKey(permissionViewClass)) {
                    throw new IllegalArgumentException("Found multiple instances of the same permission view, " + permissionViewClass + ", for a manifest ");
                }
                map.put(permissionViewClass, permissionView);
            }
        }
        this.permissionMap = Collections.unmodifiableMap(map);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        String path = this.getPath();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public Hash getContentHash() {
        return this.contentHash;
    }

    public List<Hash> getAdditionalHashes() {
        return new ArrayList<Hash>(this.additionalHashes);
    }

    public List<Hash> getAllHashes() {
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        if (this.contentHash != null) {
            hashes.add(this.contentHash);
        }
        hashes.addAll(this.additionalHashes);
        return hashes;
    }

    public int getVersion() {
        return this.version;
    }

    public FileType getType() {
        return this.type;
    }

    public long getLength() {
        return this.length;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public String getLinkPath() {
        return this.linkPath;
    }

    public <T> T getPermissionView(Class<T> viewClass) {
        return (T)this.permissionMap.get(viewClass);
    }

    public Set<?> getPermissionViews() {
        return Collections.unmodifiableSet(new HashSet<Object>(this.permissionMap.values()));
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("path", this.getPath());
        if (this.getContentHash() != null) {
            json.put("contentHash", this.getContentHash().toString());
        }
        json.put("version", this.getVersion());
        json.put("type", this.getType().name());
        if (this.getCharset() != null) {
            json.put("charset", this.getCharset().name());
        }
        json.put("length", this.getLength());
        if (this.getLastModified() != null) {
            json.put("modified", this.getLastModified());
        }
        if (FileType.SYMLINK.equals((Object)this.getType())) {
            json.put("linkPath", this.getLinkPath());
        }
        for (Object permissionView : this.getPermissionViews()) {
            if (permissionView instanceof UnixPermissions) {
                UnixPermissions unixPermissions = (UnixPermissions)permissionView;
                json.put("unixPermissions", this.getStringPermissions(unixPermissions));
                continue;
            }
            throw new JSONException("Unrecognized entry permission on entry " + this.getPath() + ", permission class " + permissionView.getClass());
        }
        List<Hash> additionalHashes = this.getAdditionalHashes();
        if (additionalHashes != null && !additionalHashes.isEmpty()) {
            JSONArray jsonHashes = new JSONArray();
            for (Hash hash : additionalHashes) {
                jsonHashes.put(hash.toString());
            }
            json.put("additionalHashes", jsonHashes);
        }
        return json;
    }

    private String getStringPermissions(UnixPermissions permissions) {
        return permissions.getOctalMode() + ":" + permissions.getUser() + ":" + permissions.getGroup();
    }

    @Override
    public int compareTo(ClientPathEntry pathEntry) {
        return this.getPath().compareTo(pathEntry.getPath());
    }

    public Charset getCharset() {
        return this.charset;
    }

    protected void setCharset(Charset charset) {
        this.charset = charset;
    }

    public ClientPathEntry(ClientPathEntryBuilder builder) {
        this.path = builder.path;
        this.contentHash = builder.contentHash;
        this.type = builder.type;
        this.length = builder.length;
        this.lastModified = builder.lastModified;
        this.linkPath = builder.linkPath;
        this.additionalHashes = builder.additionalHashes;
        this.version = builder.version;
        this.charset = builder.charset;
        HashMap map = new HashMap();
        if (builder.permissionViews != null) {
            for (Object permissionView : builder.permissionViews) {
                Class<?> permissionViewClass = permissionView.getClass();
                if (map.containsKey(permissionViewClass)) {
                    throw new IllegalArgumentException("Found multiple instances of the same permission view, " + permissionViewClass + ", for a manifest ");
                }
                map.put(permissionViewClass, permissionView);
            }
        }
        this.permissionMap = Collections.unmodifiableMap(map);
    }
}

