/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.alloc;

import com.ibm.urbancode.zos.dataset.alloc.AllocCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;

public class AllocSmsCommandBuilder
implements AllocCommandBuilder {
    private String allocCommand = "";
    private final String datasetName;

    public AllocSmsCommandBuilder(String datasetName) {
        this.datasetName = datasetName;
    }

    public AllocSmsCommandBuilder withManagementClass(String managementClass) {
        this.allocCommand = this.allocCommand + (managementClass.isEmpty() ? "" : " MGMTCLAS(" + managementClass + ")");
        return this;
    }

    public AllocSmsCommandBuilder withStorageClass(String storageClass) {
        this.allocCommand = this.allocCommand + (storageClass.isEmpty() ? "" : " STORCLAS(" + storageClass + ")");
        return this;
    }

    public AllocSmsCommandBuilder withDataClass(String dataClass) {
        this.allocCommand = this.allocCommand + (dataClass.isEmpty() ? "" : " DATACLAS(" + dataClass + ")");
        return this;
    }

    @Override
    public String getAllocCommand() {
        return this.allocCommand;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public DatasetAllocator build() {
        return new DatasetAllocator(this);
    }
}

