/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.allocate.like;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

class AllocateLikeInputs {
    public static final String DATASET_NAME = "datasetName";
    public static final String LIKE_DATASET_NAME = "likeDatasetName";
    public static final String DELETE_DATASET = "deleteDataset";
    public static final String VOLUME_SERIAL = "volumeSerial";
    public static final String SPACE_UNIT = "spaceUnit";
    public static final String PRIMARY_QUANTITY = "primaryQuantity";
    public static final String SECONDARY_QUANTITY = "secondaryQuantity";
    public static final String DEFAULT_VALUE = "---";
    private final String datasetName;
    private final String likeDatasetName;
    private final boolean isDeleteDatasetEnabled;
    private final String volumeSerial;
    private final String spaceUnit;
    private final String primaryQuantity;
    private final String secondaryQuantity;

    private AllocateLikeInputs(Properties inputProperties) {
        this.datasetName = DatasetHelper.determineFullyQualifiedDsn(inputProperties.getProperty(DATASET_NAME));
        this.likeDatasetName = DatasetHelper.determineFullyQualifiedDsn(inputProperties.getProperty(LIKE_DATASET_NAME));
        this.isDeleteDatasetEnabled = Boolean.parseBoolean(inputProperties.getProperty(DELETE_DATASET));
        this.volumeSerial = inputProperties.getProperty(VOLUME_SERIAL).trim();
        String inputSpaceUnit = inputProperties.getProperty(SPACE_UNIT);
        this.spaceUnit = inputSpaceUnit.equals(DEFAULT_VALUE) ? "" : inputSpaceUnit;
        this.primaryQuantity = inputProperties.getProperty(PRIMARY_QUANTITY).trim();
        this.secondaryQuantity = inputProperties.getProperty(SECONDARY_QUANTITY).trim();
    }

    public static AllocateLikeInputs getValidatedInputs(Properties inputProperties) throws ZFileException {
        AllocateLikeInputs pluginInputs = new AllocateLikeInputs(inputProperties);
        pluginInputs.validate();
        return pluginInputs;
    }

    private void validate() throws ZFileException {
        InputsValidator.checkIfEmpty(this.datasetName, "Dataset Name");
        if (!this.isDeleteDatasetEnabled && DatasetHelper.isDatasetExist(this.datasetName)) {
            throw new InvalidInputException("Dataset " + this.datasetName + " already exist.");
        }
        InputsValidator.checkIfEmpty(this.likeDatasetName, "Like Dataset Name");
        if (DatasetHelper.isDatasetNotExist(this.likeDatasetName)) {
            throw new MissingInputException("Like Dataset " + this.likeDatasetName + " does not exist.");
        }
        if (!this.primaryQuantity.isEmpty()) {
            InputsValidator.checkForPositiveInteger(this.primaryQuantity, "Primary Quantity");
        }
        if (!this.secondaryQuantity.isEmpty()) {
            InputsValidator.checkForPositiveInteger(this.secondaryQuantity, "Secondary Quantity");
        }
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getLikeDatasetName() {
        return this.likeDatasetName;
    }

    public boolean isDeleteDatasetEnabled() {
        return this.isDeleteDatasetEnabled;
    }

    public String getVolumeSerial() {
        return this.volumeSerial;
    }

    public String getSpaceUnit() {
        return this.spaceUnit;
    }

    public String getPrimaryQuantity() {
        return this.primaryQuantity;
    }

    public String getSecondaryQuantity() {
        return this.secondaryQuantity;
    }
}

